package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1NetworkPolicyPeerFluentImpl<A extends V1beta1NetworkPolicyPeerFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1NetworkPolicyPeerFluent<A>{

    private V1beta1IPBlockBuilder ipBlock;
    private V1LabelSelectorBuilder namespaceSelector;
    private V1LabelSelectorBuilder podSelector;

    public V1beta1NetworkPolicyPeerFluentImpl(){
    }
    public V1beta1NetworkPolicyPeerFluentImpl(V1beta1NetworkPolicyPeer instance){
            this.withIpBlock(instance.getIpBlock());

            this.withNamespaceSelector(instance.getNamespaceSelector());

            this.withPodSelector(instance.getPodSelector());

    }

    
/**
 * This method has been deprecated, please use method buildIpBlock instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1IPBlock getIpBlock(){
            return this.ipBlock!=null?this.ipBlock.build():null;
    }

    public V1beta1IPBlock buildIpBlock(){
            return this.ipBlock!=null?this.ipBlock.build():null;
    }

    public A withIpBlock(V1beta1IPBlock ipBlock){
            _visitables.get("ipBlock").remove(this.ipBlock);
            if (ipBlock!=null){ this.ipBlock= new V1beta1IPBlockBuilder(ipBlock); _visitables.get("ipBlock").add(this.ipBlock);} return (A) this;
    }

    public Boolean hasIpBlock(){
            return this.ipBlock != null;
    }

    public V1beta1NetworkPolicyPeerFluent.IpBlockNested<A> withNewIpBlock(){
            return new IpBlockNestedImpl();
    }

    public V1beta1NetworkPolicyPeerFluent.IpBlockNested<A> withNewIpBlockLike(V1beta1IPBlock item){
            return new IpBlockNestedImpl(item);
    }

    public V1beta1NetworkPolicyPeerFluent.IpBlockNested<A> editIpBlock(){
            return withNewIpBlockLike(getIpBlock());
    }

    public V1beta1NetworkPolicyPeerFluent.IpBlockNested<A> editOrNewIpBlock(){
            return withNewIpBlockLike(getIpBlock() != null ? getIpBlock(): new V1beta1IPBlockBuilder().build());
    }

    public V1beta1NetworkPolicyPeerFluent.IpBlockNested<A> editOrNewIpBlockLike(V1beta1IPBlock item){
            return withNewIpBlockLike(getIpBlock() != null ? getIpBlock(): item);
    }

    
/**
 * This method has been deprecated, please use method buildNamespaceSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getNamespaceSelector(){
            return this.namespaceSelector!=null?this.namespaceSelector.build():null;
    }

    public V1LabelSelector buildNamespaceSelector(){
            return this.namespaceSelector!=null?this.namespaceSelector.build():null;
    }

    public A withNamespaceSelector(V1LabelSelector namespaceSelector){
            _visitables.get("namespaceSelector").remove(this.namespaceSelector);
            if (namespaceSelector!=null){ this.namespaceSelector= new V1LabelSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} return (A) this;
    }

    public Boolean hasNamespaceSelector(){
            return this.namespaceSelector != null;
    }

    public V1beta1NetworkPolicyPeerFluent.NamespaceSelectorNested<A> withNewNamespaceSelector(){
            return new NamespaceSelectorNestedImpl();
    }

    public V1beta1NetworkPolicyPeerFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(V1LabelSelector item){
            return new NamespaceSelectorNestedImpl(item);
    }

    public V1beta1NetworkPolicyPeerFluent.NamespaceSelectorNested<A> editNamespaceSelector(){
            return withNewNamespaceSelectorLike(getNamespaceSelector());
    }

    public V1beta1NetworkPolicyPeerFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector(){
            return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new V1LabelSelectorBuilder().build());
    }

    public V1beta1NetworkPolicyPeerFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(V1LabelSelector item){
            return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPodSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getPodSelector(){
            return this.podSelector!=null?this.podSelector.build():null;
    }

    public V1LabelSelector buildPodSelector(){
            return this.podSelector!=null?this.podSelector.build():null;
    }

    public A withPodSelector(V1LabelSelector podSelector){
            _visitables.get("podSelector").remove(this.podSelector);
            if (podSelector!=null){ this.podSelector= new V1LabelSelectorBuilder(podSelector); _visitables.get("podSelector").add(this.podSelector);} return (A) this;
    }

    public Boolean hasPodSelector(){
            return this.podSelector != null;
    }

    public V1beta1NetworkPolicyPeerFluent.PodSelectorNested<A> withNewPodSelector(){
            return new PodSelectorNestedImpl();
    }

    public V1beta1NetworkPolicyPeerFluent.PodSelectorNested<A> withNewPodSelectorLike(V1LabelSelector item){
            return new PodSelectorNestedImpl(item);
    }

    public V1beta1NetworkPolicyPeerFluent.PodSelectorNested<A> editPodSelector(){
            return withNewPodSelectorLike(getPodSelector());
    }

    public V1beta1NetworkPolicyPeerFluent.PodSelectorNested<A> editOrNewPodSelector(){
            return withNewPodSelectorLike(getPodSelector() != null ? getPodSelector(): new V1LabelSelectorBuilder().build());
    }

    public V1beta1NetworkPolicyPeerFluent.PodSelectorNested<A> editOrNewPodSelectorLike(V1LabelSelector item){
            return withNewPodSelectorLike(getPodSelector() != null ? getPodSelector(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1beta1NetworkPolicyPeerFluentImpl that = (V1beta1NetworkPolicyPeerFluentImpl) o;
            if (ipBlock != null ? !ipBlock.equals(that.ipBlock) :that.ipBlock != null) return false;
            if (namespaceSelector != null ? !namespaceSelector.equals(that.namespaceSelector) :that.namespaceSelector != null) return false;
            if (podSelector != null ? !podSelector.equals(that.podSelector) :that.podSelector != null) return false;
            return true;
    }


    public class IpBlockNestedImpl<N> extends V1beta1IPBlockFluentImpl<V1beta1NetworkPolicyPeerFluent.IpBlockNested<N>> implements V1beta1NetworkPolicyPeerFluent.IpBlockNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1IPBlockBuilder builder;
    
            IpBlockNestedImpl(V1beta1IPBlock item){
                    this.builder = new V1beta1IPBlockBuilder(this, item);
            }
            IpBlockNestedImpl(){
                    this.builder = new V1beta1IPBlockBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1NetworkPolicyPeerFluentImpl.this.withIpBlock(builder.build());
    }
    public N endIpBlock(){
            return and();
    }

}
    public class NamespaceSelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<V1beta1NetworkPolicyPeerFluent.NamespaceSelectorNested<N>> implements V1beta1NetworkPolicyPeerFluent.NamespaceSelectorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorBuilder builder;
    
            NamespaceSelectorNestedImpl(V1LabelSelector item){
                    this.builder = new V1LabelSelectorBuilder(this, item);
            }
            NamespaceSelectorNestedImpl(){
                    this.builder = new V1LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1NetworkPolicyPeerFluentImpl.this.withNamespaceSelector(builder.build());
    }
    public N endNamespaceSelector(){
            return and();
    }

}
    public class PodSelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<V1beta1NetworkPolicyPeerFluent.PodSelectorNested<N>> implements V1beta1NetworkPolicyPeerFluent.PodSelectorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorBuilder builder;
    
            PodSelectorNestedImpl(V1LabelSelector item){
                    this.builder = new V1LabelSelectorBuilder(this, item);
            }
            PodSelectorNestedImpl(){
                    this.builder = new V1LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1NetworkPolicyPeerFluentImpl.this.withPodSelector(builder.build());
    }
    public N endPodSelector(){
            return and();
    }

}


}
