package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class V1beta1NetworkPolicyIngressRuleFluentImpl<A extends V1beta1NetworkPolicyIngressRuleFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1NetworkPolicyIngressRuleFluent<A>{

    private List<V1beta1NetworkPolicyPeerBuilder> from;
    private List<V1beta1NetworkPolicyPortBuilder> ports;

    public V1beta1NetworkPolicyIngressRuleFluentImpl(){
    }
    public V1beta1NetworkPolicyIngressRuleFluentImpl(V1beta1NetworkPolicyIngressRule instance){
            this.withFrom(instance.getFrom());

            this.withPorts(instance.getPorts());

    }

    public A addToFrom(int index,V1beta1NetworkPolicyPeer item){
            if (this.from == null) {this.from = new ArrayList<V1beta1NetworkPolicyPeerBuilder>();}
            V1beta1NetworkPolicyPeerBuilder builder = new V1beta1NetworkPolicyPeerBuilder(item);_visitables.get("from").add(index >= 0 ? index : _visitables.get("from").size(), builder);this.from.add(index >= 0 ? index : from.size(), builder); return (A)this;
    }

    public A setToFrom(int index,V1beta1NetworkPolicyPeer item){
            if (this.from == null) {this.from = new ArrayList<V1beta1NetworkPolicyPeerBuilder>();}
            V1beta1NetworkPolicyPeerBuilder builder = new V1beta1NetworkPolicyPeerBuilder(item);
            if (index < 0 || index >= _visitables.get("from").size()) { _visitables.get("from").add(builder); } else { _visitables.get("from").set(index, builder);}
            if (index < 0 || index >= from.size()) { from.add(builder); } else { from.set(index, builder);}
             return (A)this;
    }

    public A addToFrom(V1beta1NetworkPolicyPeer... items){
            if (this.from == null) {this.from = new ArrayList<V1beta1NetworkPolicyPeerBuilder>();}
            for (V1beta1NetworkPolicyPeer item : items) {V1beta1NetworkPolicyPeerBuilder builder = new V1beta1NetworkPolicyPeerBuilder(item);_visitables.get("from").add(builder);this.from.add(builder);} return (A)this;
    }

    public A addAllToFrom(Collection<V1beta1NetworkPolicyPeer> items){
            if (this.from == null) {this.from = new ArrayList<V1beta1NetworkPolicyPeerBuilder>();}
            for (V1beta1NetworkPolicyPeer item : items) {V1beta1NetworkPolicyPeerBuilder builder = new V1beta1NetworkPolicyPeerBuilder(item);_visitables.get("from").add(builder);this.from.add(builder);} return (A)this;
    }

    public A removeFromFrom(V1beta1NetworkPolicyPeer... items){
            for (V1beta1NetworkPolicyPeer item : items) {V1beta1NetworkPolicyPeerBuilder builder = new V1beta1NetworkPolicyPeerBuilder(item);_visitables.get("from").remove(builder);if (this.from != null) {this.from.remove(builder);}} return (A)this;
    }

    public A removeAllFromFrom(Collection<V1beta1NetworkPolicyPeer> items){
            for (V1beta1NetworkPolicyPeer item : items) {V1beta1NetworkPolicyPeerBuilder builder = new V1beta1NetworkPolicyPeerBuilder(item);_visitables.get("from").remove(builder);if (this.from != null) {this.from.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromFrom(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyPeerBuilder> predicate){
            if (from == null) return (A) this;
            final Iterator<V1beta1NetworkPolicyPeerBuilder> each = from.iterator();
            final List visitables = _visitables.get("from");
            while (each.hasNext()) {
              V1beta1NetworkPolicyPeerBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildFrom instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1NetworkPolicyPeer> getFrom(){
            return build(from);
    }

    public List<V1beta1NetworkPolicyPeer> buildFrom(){
            return build(from);
    }

    public V1beta1NetworkPolicyPeer buildFrom(int index){
            return this.from.get(index).build();
    }

    public V1beta1NetworkPolicyPeer buildFirstFrom(){
            return this.from.get(0).build();
    }

    public V1beta1NetworkPolicyPeer buildLastFrom(){
            return this.from.get(from.size() - 1).build();
    }

    public V1beta1NetworkPolicyPeer buildMatchingFrom(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyPeerBuilder> predicate){
            for (V1beta1NetworkPolicyPeerBuilder item: from) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingFrom(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyPeerBuilder> predicate){
            for (V1beta1NetworkPolicyPeerBuilder item: from) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withFrom(List<V1beta1NetworkPolicyPeer> from){
            if (this.from != null) { _visitables.get("from").removeAll(this.from);}
            if (from != null) {this.from = new ArrayList<V1beta1NetworkPolicyPeerBuilder>(); for (V1beta1NetworkPolicyPeer item : from){this.addToFrom(item);}} else { this.from = null;} return (A) this;
    }

    public A withFrom(V1beta1NetworkPolicyPeer... from){
            if (this.from != null) {this.from.clear();}
            if (from != null) {for (V1beta1NetworkPolicyPeer item :from){ this.addToFrom(item);}} return (A) this;
    }

    public Boolean hasFrom(){
            return from != null && !from.isEmpty();
    }

    public V1beta1NetworkPolicyIngressRuleFluent.FromNested<A> addNewFrom(){
            return new FromNestedImpl();
    }

    public V1beta1NetworkPolicyIngressRuleFluent.FromNested<A> addNewFromLike(V1beta1NetworkPolicyPeer item){
            return new FromNestedImpl(-1, item);
    }

    public V1beta1NetworkPolicyIngressRuleFluent.FromNested<A> setNewFromLike(int index,V1beta1NetworkPolicyPeer item){
            return new FromNestedImpl(index, item);
    }

    public V1beta1NetworkPolicyIngressRuleFluent.FromNested<A> editFrom(int index){
            if (from.size() <= index) throw new RuntimeException("Can't edit from. Index exceeds size.");
            return setNewFromLike(index, buildFrom(index));
    }

    public V1beta1NetworkPolicyIngressRuleFluent.FromNested<A> editFirstFrom(){
            if (from.size() == 0) throw new RuntimeException("Can't edit first from. The list is empty.");
            return setNewFromLike(0, buildFrom(0));
    }

    public V1beta1NetworkPolicyIngressRuleFluent.FromNested<A> editLastFrom(){
            int index = from.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last from. The list is empty.");
            return setNewFromLike(index, buildFrom(index));
    }

    public V1beta1NetworkPolicyIngressRuleFluent.FromNested<A> editMatchingFrom(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyPeerBuilder> predicate){
            int index = -1;
            for (int i=0;i<from.size();i++) { 
            if (predicate.apply(from.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching from. No match found.");
            return setNewFromLike(index, buildFrom(index));
    }

    public A addToPorts(int index,V1beta1NetworkPolicyPort item){
            if (this.ports == null) {this.ports = new ArrayList<V1beta1NetworkPolicyPortBuilder>();}
            V1beta1NetworkPolicyPortBuilder builder = new V1beta1NetworkPolicyPortBuilder(item);_visitables.get("ports").add(index >= 0 ? index : _visitables.get("ports").size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
    }

    public A setToPorts(int index,V1beta1NetworkPolicyPort item){
            if (this.ports == null) {this.ports = new ArrayList<V1beta1NetworkPolicyPortBuilder>();}
            V1beta1NetworkPolicyPortBuilder builder = new V1beta1NetworkPolicyPortBuilder(item);
            if (index < 0 || index >= _visitables.get("ports").size()) { _visitables.get("ports").add(builder); } else { _visitables.get("ports").set(index, builder);}
            if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
             return (A)this;
    }

    public A addToPorts(V1beta1NetworkPolicyPort... items){
            if (this.ports == null) {this.ports = new ArrayList<V1beta1NetworkPolicyPortBuilder>();}
            for (V1beta1NetworkPolicyPort item : items) {V1beta1NetworkPolicyPortBuilder builder = new V1beta1NetworkPolicyPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
    }

    public A addAllToPorts(Collection<V1beta1NetworkPolicyPort> items){
            if (this.ports == null) {this.ports = new ArrayList<V1beta1NetworkPolicyPortBuilder>();}
            for (V1beta1NetworkPolicyPort item : items) {V1beta1NetworkPolicyPortBuilder builder = new V1beta1NetworkPolicyPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
    }

    public A removeFromPorts(V1beta1NetworkPolicyPort... items){
            for (V1beta1NetworkPolicyPort item : items) {V1beta1NetworkPolicyPortBuilder builder = new V1beta1NetworkPolicyPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeAllFromPorts(Collection<V1beta1NetworkPolicyPort> items){
            for (V1beta1NetworkPolicyPort item : items) {V1beta1NetworkPolicyPortBuilder builder = new V1beta1NetworkPolicyPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPorts(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyPortBuilder> predicate){
            if (ports == null) return (A) this;
            final Iterator<V1beta1NetworkPolicyPortBuilder> each = ports.iterator();
            final List visitables = _visitables.get("ports");
            while (each.hasNext()) {
              V1beta1NetworkPolicyPortBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1NetworkPolicyPort> getPorts(){
            return build(ports);
    }

    public List<V1beta1NetworkPolicyPort> buildPorts(){
            return build(ports);
    }

    public V1beta1NetworkPolicyPort buildPort(int index){
            return this.ports.get(index).build();
    }

    public V1beta1NetworkPolicyPort buildFirstPort(){
            return this.ports.get(0).build();
    }

    public V1beta1NetworkPolicyPort buildLastPort(){
            return this.ports.get(ports.size() - 1).build();
    }

    public V1beta1NetworkPolicyPort buildMatchingPort(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyPortBuilder> predicate){
            for (V1beta1NetworkPolicyPortBuilder item: ports) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingPort(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyPortBuilder> predicate){
            for (V1beta1NetworkPolicyPortBuilder item: ports) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withPorts(List<V1beta1NetworkPolicyPort> ports){
            if (this.ports != null) { _visitables.get("ports").removeAll(this.ports);}
            if (ports != null) {this.ports = new ArrayList<V1beta1NetworkPolicyPortBuilder>(); for (V1beta1NetworkPolicyPort item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
    }

    public A withPorts(V1beta1NetworkPolicyPort... ports){
            if (this.ports != null) {this.ports.clear();}
            if (ports != null) {for (V1beta1NetworkPolicyPort item :ports){ this.addToPorts(item);}} return (A) this;
    }

    public Boolean hasPorts(){
            return ports != null && !ports.isEmpty();
    }

    public V1beta1NetworkPolicyIngressRuleFluent.PortsNested<A> addNewPort(){
            return new PortsNestedImpl();
    }

    public V1beta1NetworkPolicyIngressRuleFluent.PortsNested<A> addNewPortLike(V1beta1NetworkPolicyPort item){
            return new PortsNestedImpl(-1, item);
    }

    public V1beta1NetworkPolicyIngressRuleFluent.PortsNested<A> setNewPortLike(int index,V1beta1NetworkPolicyPort item){
            return new PortsNestedImpl(index, item);
    }

    public V1beta1NetworkPolicyIngressRuleFluent.PortsNested<A> editPort(int index){
            if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
            return setNewPortLike(index, buildPort(index));
    }

    public V1beta1NetworkPolicyIngressRuleFluent.PortsNested<A> editFirstPort(){
            if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
            return setNewPortLike(0, buildPort(0));
    }

    public V1beta1NetworkPolicyIngressRuleFluent.PortsNested<A> editLastPort(){
            int index = ports.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
            return setNewPortLike(index, buildPort(index));
    }

    public V1beta1NetworkPolicyIngressRuleFluent.PortsNested<A> editMatchingPort(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyPortBuilder> predicate){
            int index = -1;
            for (int i=0;i<ports.size();i++) { 
            if (predicate.apply(ports.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
            return setNewPortLike(index, buildPort(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1beta1NetworkPolicyIngressRuleFluentImpl that = (V1beta1NetworkPolicyIngressRuleFluentImpl) o;
            if (from != null ? !from.equals(that.from) :that.from != null) return false;
            if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
            return true;
    }


    public class FromNestedImpl<N> extends V1beta1NetworkPolicyPeerFluentImpl<V1beta1NetworkPolicyIngressRuleFluent.FromNested<N>> implements V1beta1NetworkPolicyIngressRuleFluent.FromNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1NetworkPolicyPeerBuilder builder;
        private final int index;
    
            FromNestedImpl(int index,V1beta1NetworkPolicyPeer item){
                    this.index = index;
                    this.builder = new V1beta1NetworkPolicyPeerBuilder(this, item);
            }
            FromNestedImpl(){
                    this.index = -1;
                    this.builder = new V1beta1NetworkPolicyPeerBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1NetworkPolicyIngressRuleFluentImpl.this.setToFrom(index,builder.build());
    }
    public N endFrom(){
            return and();
    }

}
    public class PortsNestedImpl<N> extends V1beta1NetworkPolicyPortFluentImpl<V1beta1NetworkPolicyIngressRuleFluent.PortsNested<N>> implements V1beta1NetworkPolicyIngressRuleFluent.PortsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1NetworkPolicyPortBuilder builder;
        private final int index;
    
            PortsNestedImpl(int index,V1beta1NetworkPolicyPort item){
                    this.index = index;
                    this.builder = new V1beta1NetworkPolicyPortBuilder(this, item);
            }
            PortsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1beta1NetworkPolicyPortBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1NetworkPolicyIngressRuleFluentImpl.this.setToPorts(index,builder.build());
    }
    public N endPort(){
            return and();
    }

}


}
