package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;

public class V1beta1DaemonSetSpecFluentImpl<A extends V1beta1DaemonSetSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1DaemonSetSpecFluent<A>{

    private Integer minReadySeconds;
    private Integer revisionHistoryLimit;
    private V1LabelSelectorBuilder selector;
    private V1PodTemplateSpecBuilder template;
    private Long templateGeneration;
    private V1beta1DaemonSetUpdateStrategyBuilder updateStrategy;

    public V1beta1DaemonSetSpecFluentImpl(){
    }
    public V1beta1DaemonSetSpecFluentImpl(V1beta1DaemonSetSpec instance){
            this.withMinReadySeconds(instance.getMinReadySeconds());

            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());

            this.withSelector(instance.getSelector());

            this.withTemplate(instance.getTemplate());

            this.withTemplateGeneration(instance.getTemplateGeneration());

            this.withUpdateStrategy(instance.getUpdateStrategy());

    }

    public Integer getMinReadySeconds(){
            return this.minReadySeconds;
    }

    public A withMinReadySeconds(Integer minReadySeconds){
            this.minReadySeconds=minReadySeconds; return (A) this;
    }

    public Boolean hasMinReadySeconds(){
            return this.minReadySeconds != null;
    }

    public Integer getRevisionHistoryLimit(){
            return this.revisionHistoryLimit;
    }

    public A withRevisionHistoryLimit(Integer revisionHistoryLimit){
            this.revisionHistoryLimit=revisionHistoryLimit; return (A) this;
    }

    public Boolean hasRevisionHistoryLimit(){
            return this.revisionHistoryLimit != null;
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public V1LabelSelector buildSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(V1LabelSelector selector){
            _visitables.get("selector").remove(this.selector);
            if (selector!=null){ this.selector= new V1LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector(){
            return this.selector != null;
    }

    public V1beta1DaemonSetSpecFluent.SelectorNested<A> withNewSelector(){
            return new SelectorNestedImpl();
    }

    public V1beta1DaemonSetSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item){
            return new SelectorNestedImpl(item);
    }

    public V1beta1DaemonSetSpecFluent.SelectorNested<A> editSelector(){
            return withNewSelectorLike(getSelector());
    }

    public V1beta1DaemonSetSpecFluent.SelectorNested<A> editOrNewSelector(){
            return withNewSelectorLike(getSelector() != null ? getSelector(): new V1LabelSelectorBuilder().build());
    }

    public V1beta1DaemonSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item){
            return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V1PodTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public V1PodTemplateSpec buildTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(V1PodTemplateSpec template){
            _visitables.get("template").remove(this.template);
            if (template!=null){ this.template= new V1PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template != null;
    }

    public V1beta1DaemonSetSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public V1beta1DaemonSetSpecFluent.TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public V1beta1DaemonSetSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public V1beta1DaemonSetSpecFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new V1PodTemplateSpecBuilder().build());
    }

    public V1beta1DaemonSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public Long getTemplateGeneration(){
            return this.templateGeneration;
    }

    public A withTemplateGeneration(Long templateGeneration){
            this.templateGeneration=templateGeneration; return (A) this;
    }

    public Boolean hasTemplateGeneration(){
            return this.templateGeneration != null;
    }

    
/**
 * This method has been deprecated, please use method buildUpdateStrategy instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1DaemonSetUpdateStrategy getUpdateStrategy(){
            return this.updateStrategy!=null?this.updateStrategy.build():null;
    }

    public V1beta1DaemonSetUpdateStrategy buildUpdateStrategy(){
            return this.updateStrategy!=null?this.updateStrategy.build():null;
    }

    public A withUpdateStrategy(V1beta1DaemonSetUpdateStrategy updateStrategy){
            _visitables.get("updateStrategy").remove(this.updateStrategy);
            if (updateStrategy!=null){ this.updateStrategy= new V1beta1DaemonSetUpdateStrategyBuilder(updateStrategy); _visitables.get("updateStrategy").add(this.updateStrategy);} return (A) this;
    }

    public Boolean hasUpdateStrategy(){
            return this.updateStrategy != null;
    }

    public V1beta1DaemonSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy(){
            return new UpdateStrategyNestedImpl();
    }

    public V1beta1DaemonSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(V1beta1DaemonSetUpdateStrategy item){
            return new UpdateStrategyNestedImpl(item);
    }

    public V1beta1DaemonSetSpecFluent.UpdateStrategyNested<A> editUpdateStrategy(){
            return withNewUpdateStrategyLike(getUpdateStrategy());
    }

    public V1beta1DaemonSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy(){
            return withNewUpdateStrategyLike(getUpdateStrategy() != null ? getUpdateStrategy(): new V1beta1DaemonSetUpdateStrategyBuilder().build());
    }

    public V1beta1DaemonSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(V1beta1DaemonSetUpdateStrategy item){
            return withNewUpdateStrategyLike(getUpdateStrategy() != null ? getUpdateStrategy(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1beta1DaemonSetSpecFluentImpl that = (V1beta1DaemonSetSpecFluentImpl) o;
            if (minReadySeconds != null ? !minReadySeconds.equals(that.minReadySeconds) :that.minReadySeconds != null) return false;
            if (revisionHistoryLimit != null ? !revisionHistoryLimit.equals(that.revisionHistoryLimit) :that.revisionHistoryLimit != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            if (templateGeneration != null ? !templateGeneration.equals(that.templateGeneration) :that.templateGeneration != null) return false;
            if (updateStrategy != null ? !updateStrategy.equals(that.updateStrategy) :that.updateStrategy != null) return false;
            return true;
    }


    public class SelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<V1beta1DaemonSetSpecFluent.SelectorNested<N>> implements V1beta1DaemonSetSpecFluent.SelectorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorBuilder builder;
    
            SelectorNestedImpl(V1LabelSelector item){
                    this.builder = new V1LabelSelectorBuilder(this, item);
            }
            SelectorNestedImpl(){
                    this.builder = new V1LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1DaemonSetSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends V1PodTemplateSpecFluentImpl<V1beta1DaemonSetSpecFluent.TemplateNested<N>> implements V1beta1DaemonSetSpecFluent.TemplateNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1PodTemplateSpecBuilder builder;
    
            TemplateNestedImpl(V1PodTemplateSpec item){
                    this.builder = new V1PodTemplateSpecBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new V1PodTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1DaemonSetSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}
    public class UpdateStrategyNestedImpl<N> extends V1beta1DaemonSetUpdateStrategyFluentImpl<V1beta1DaemonSetSpecFluent.UpdateStrategyNested<N>> implements V1beta1DaemonSetSpecFluent.UpdateStrategyNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1DaemonSetUpdateStrategyBuilder builder;
    
            UpdateStrategyNestedImpl(V1beta1DaemonSetUpdateStrategy item){
                    this.builder = new V1beta1DaemonSetUpdateStrategyBuilder(this, item);
            }
            UpdateStrategyNestedImpl(){
                    this.builder = new V1beta1DaemonSetUpdateStrategyBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1DaemonSetSpecFluentImpl.this.withUpdateStrategy(builder.build());
    }
    public N endUpdateStrategy(){
            return and();
    }

}


}
