package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1CertificateSigningRequestBuilder extends V1beta1CertificateSigningRequestFluentImpl<V1beta1CertificateSigningRequestBuilder> implements VisitableBuilder<V1beta1CertificateSigningRequest,V1beta1CertificateSigningRequestBuilder>{

    V1beta1CertificateSigningRequestFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1CertificateSigningRequestBuilder(){
            this(true);
    }
    public V1beta1CertificateSigningRequestBuilder(Boolean validationEnabled){
            this(new V1beta1CertificateSigningRequest(), validationEnabled);
    }
    public V1beta1CertificateSigningRequestBuilder(V1beta1CertificateSigningRequestFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1CertificateSigningRequestBuilder(V1beta1CertificateSigningRequestFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1CertificateSigningRequest(), validationEnabled);
    }
    public V1beta1CertificateSigningRequestBuilder(V1beta1CertificateSigningRequestFluent<?> fluent,V1beta1CertificateSigningRequest instance){
            this(fluent, instance, true);
    }
    public V1beta1CertificateSigningRequestBuilder(V1beta1CertificateSigningRequestFluent<?> fluent,V1beta1CertificateSigningRequest instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1CertificateSigningRequestBuilder(V1beta1CertificateSigningRequest instance){
            this(instance,true);
    }
    public V1beta1CertificateSigningRequestBuilder(V1beta1CertificateSigningRequest instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1CertificateSigningRequest build(){
            V1beta1CertificateSigningRequest buildable = new V1beta1CertificateSigningRequest();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1CertificateSigningRequestBuilder that = (V1beta1CertificateSigningRequestBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
