package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1RoleListBuilder extends V1alpha1RoleListFluentImpl<V1alpha1RoleListBuilder> implements VisitableBuilder<V1alpha1RoleList,V1alpha1RoleListBuilder>{

    V1alpha1RoleListFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1RoleListBuilder(){
            this(true);
    }
    public V1alpha1RoleListBuilder(Boolean validationEnabled){
            this(new V1alpha1RoleList(), validationEnabled);
    }
    public V1alpha1RoleListBuilder(V1alpha1RoleListFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1RoleListBuilder(V1alpha1RoleListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1RoleList(), validationEnabled);
    }
    public V1alpha1RoleListBuilder(V1alpha1RoleListFluent<?> fluent,V1alpha1RoleList instance){
            this(fluent, instance, true);
    }
    public V1alpha1RoleListBuilder(V1alpha1RoleListFluent<?> fluent,V1alpha1RoleList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1RoleListBuilder(V1alpha1RoleList instance){
            this(instance,true);
    }
    public V1alpha1RoleListBuilder(V1alpha1RoleList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1RoleList build(){
            V1alpha1RoleList buildable = new V1alpha1RoleList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1RoleListBuilder that = (V1alpha1RoleListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
