package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1EndpointSliceListBuilder extends V1alpha1EndpointSliceListFluentImpl<V1alpha1EndpointSliceListBuilder> implements VisitableBuilder<V1alpha1EndpointSliceList,V1alpha1EndpointSliceListBuilder>{

    V1alpha1EndpointSliceListFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1EndpointSliceListBuilder(){
            this(true);
    }
    public V1alpha1EndpointSliceListBuilder(Boolean validationEnabled){
            this(new V1alpha1EndpointSliceList(), validationEnabled);
    }
    public V1alpha1EndpointSliceListBuilder(V1alpha1EndpointSliceListFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1EndpointSliceListBuilder(V1alpha1EndpointSliceListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1EndpointSliceList(), validationEnabled);
    }
    public V1alpha1EndpointSliceListBuilder(V1alpha1EndpointSliceListFluent<?> fluent,V1alpha1EndpointSliceList instance){
            this(fluent, instance, true);
    }
    public V1alpha1EndpointSliceListBuilder(V1alpha1EndpointSliceListFluent<?> fluent,V1alpha1EndpointSliceList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1EndpointSliceListBuilder(V1alpha1EndpointSliceList instance){
            this(instance,true);
    }
    public V1alpha1EndpointSliceListBuilder(V1alpha1EndpointSliceList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1EndpointSliceList build(){
            V1alpha1EndpointSliceList buildable = new V1alpha1EndpointSliceList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1EndpointSliceListBuilder that = (V1alpha1EndpointSliceListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
