package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1TopologySpreadConstraintFluentImpl<A extends V1TopologySpreadConstraintFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1TopologySpreadConstraintFluent<A>{

    private V1LabelSelectorBuilder labelSelector;
    private Integer maxSkew;
    private String topologyKey;
    private String whenUnsatisfiable;

    public V1TopologySpreadConstraintFluentImpl(){
    }
    public V1TopologySpreadConstraintFluentImpl(V1TopologySpreadConstraint instance){
            this.withLabelSelector(instance.getLabelSelector());

            this.withMaxSkew(instance.getMaxSkew());

            this.withTopologyKey(instance.getTopologyKey());

            this.withWhenUnsatisfiable(instance.getWhenUnsatisfiable());

    }

    
/**
 * This method has been deprecated, please use method buildLabelSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getLabelSelector(){
            return this.labelSelector!=null?this.labelSelector.build():null;
    }

    public V1LabelSelector buildLabelSelector(){
            return this.labelSelector!=null?this.labelSelector.build():null;
    }

    public A withLabelSelector(V1LabelSelector labelSelector){
            _visitables.get("labelSelector").remove(this.labelSelector);
            if (labelSelector!=null){ this.labelSelector= new V1LabelSelectorBuilder(labelSelector); _visitables.get("labelSelector").add(this.labelSelector);} return (A) this;
    }

    public Boolean hasLabelSelector(){
            return this.labelSelector != null;
    }

    public V1TopologySpreadConstraintFluent.LabelSelectorNested<A> withNewLabelSelector(){
            return new LabelSelectorNestedImpl();
    }

    public V1TopologySpreadConstraintFluent.LabelSelectorNested<A> withNewLabelSelectorLike(V1LabelSelector item){
            return new LabelSelectorNestedImpl(item);
    }

    public V1TopologySpreadConstraintFluent.LabelSelectorNested<A> editLabelSelector(){
            return withNewLabelSelectorLike(getLabelSelector());
    }

    public V1TopologySpreadConstraintFluent.LabelSelectorNested<A> editOrNewLabelSelector(){
            return withNewLabelSelectorLike(getLabelSelector() != null ? getLabelSelector(): new V1LabelSelectorBuilder().build());
    }

    public V1TopologySpreadConstraintFluent.LabelSelectorNested<A> editOrNewLabelSelectorLike(V1LabelSelector item){
            return withNewLabelSelectorLike(getLabelSelector() != null ? getLabelSelector(): item);
    }

    public Integer getMaxSkew(){
            return this.maxSkew;
    }

    public A withMaxSkew(Integer maxSkew){
            this.maxSkew=maxSkew; return (A) this;
    }

    public Boolean hasMaxSkew(){
            return this.maxSkew != null;
    }

    public String getTopologyKey(){
            return this.topologyKey;
    }

    public A withTopologyKey(String topologyKey){
            this.topologyKey=topologyKey; return (A) this;
    }

    public Boolean hasTopologyKey(){
            return this.topologyKey != null;
    }

    public A withNewTopologyKey(String arg1){
            return (A)withTopologyKey(new String(arg1));
    }

    public A withNewTopologyKey(StringBuilder arg1){
            return (A)withTopologyKey(new String(arg1));
    }

    public A withNewTopologyKey(StringBuffer arg1){
            return (A)withTopologyKey(new String(arg1));
    }

    public String getWhenUnsatisfiable(){
            return this.whenUnsatisfiable;
    }

    public A withWhenUnsatisfiable(String whenUnsatisfiable){
            this.whenUnsatisfiable=whenUnsatisfiable; return (A) this;
    }

    public Boolean hasWhenUnsatisfiable(){
            return this.whenUnsatisfiable != null;
    }

    public A withNewWhenUnsatisfiable(String arg1){
            return (A)withWhenUnsatisfiable(new String(arg1));
    }

    public A withNewWhenUnsatisfiable(StringBuilder arg1){
            return (A)withWhenUnsatisfiable(new String(arg1));
    }

    public A withNewWhenUnsatisfiable(StringBuffer arg1){
            return (A)withWhenUnsatisfiable(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1TopologySpreadConstraintFluentImpl that = (V1TopologySpreadConstraintFluentImpl) o;
            if (labelSelector != null ? !labelSelector.equals(that.labelSelector) :that.labelSelector != null) return false;
            if (maxSkew != null ? !maxSkew.equals(that.maxSkew) :that.maxSkew != null) return false;
            if (topologyKey != null ? !topologyKey.equals(that.topologyKey) :that.topologyKey != null) return false;
            if (whenUnsatisfiable != null ? !whenUnsatisfiable.equals(that.whenUnsatisfiable) :that.whenUnsatisfiable != null) return false;
            return true;
    }


    public class LabelSelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<V1TopologySpreadConstraintFluent.LabelSelectorNested<N>> implements V1TopologySpreadConstraintFluent.LabelSelectorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorBuilder builder;
    
            LabelSelectorNestedImpl(V1LabelSelector item){
                    this.builder = new V1LabelSelectorBuilder(this, item);
            }
            LabelSelectorNestedImpl(){
                    this.builder = new V1LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) V1TopologySpreadConstraintFluentImpl.this.withLabelSelector(builder.build());
    }
    public N endLabelSelector(){
            return and();
    }

}


}
