package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ScaleSpecBuilder extends V1ScaleSpecFluentImpl<V1ScaleSpecBuilder> implements VisitableBuilder<V1ScaleSpec,V1ScaleSpecBuilder>{

    V1ScaleSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1ScaleSpecBuilder(){
            this(true);
    }
    public V1ScaleSpecBuilder(Boolean validationEnabled){
            this(new V1ScaleSpec(), validationEnabled);
    }
    public V1ScaleSpecBuilder(V1ScaleSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1ScaleSpecBuilder(V1ScaleSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1ScaleSpec(), validationEnabled);
    }
    public V1ScaleSpecBuilder(V1ScaleSpecFluent<?> fluent,V1ScaleSpec instance){
            this(fluent, instance, true);
    }
    public V1ScaleSpecBuilder(V1ScaleSpecFluent<?> fluent,V1ScaleSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withReplicas(instance.getReplicas());

            this.validationEnabled = validationEnabled; 
    }
    public V1ScaleSpecBuilder(V1ScaleSpec instance){
            this(instance,true);
    }
    public V1ScaleSpecBuilder(V1ScaleSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withReplicas(instance.getReplicas());

            this.validationEnabled = validationEnabled; 
    }

    public V1ScaleSpec build(){
            V1ScaleSpec buildable = new V1ScaleSpec();
            buildable.setReplicas(fluent.getReplicas());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ScaleSpecBuilder that = (V1ScaleSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
