package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1RollingUpdateDeploymentBuilder extends V1RollingUpdateDeploymentFluentImpl<V1RollingUpdateDeploymentBuilder> implements VisitableBuilder<V1RollingUpdateDeployment,V1RollingUpdateDeploymentBuilder>{

    V1RollingUpdateDeploymentFluent<?> fluent;
    Boolean validationEnabled;

    public V1RollingUpdateDeploymentBuilder(){
            this(true);
    }
    public V1RollingUpdateDeploymentBuilder(Boolean validationEnabled){
            this(new V1RollingUpdateDeployment(), validationEnabled);
    }
    public V1RollingUpdateDeploymentBuilder(V1RollingUpdateDeploymentFluent<?> fluent){
            this(fluent, true);
    }
    public V1RollingUpdateDeploymentBuilder(V1RollingUpdateDeploymentFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1RollingUpdateDeployment(), validationEnabled);
    }
    public V1RollingUpdateDeploymentBuilder(V1RollingUpdateDeploymentFluent<?> fluent,V1RollingUpdateDeployment instance){
            this(fluent, instance, true);
    }
    public V1RollingUpdateDeploymentBuilder(V1RollingUpdateDeploymentFluent<?> fluent,V1RollingUpdateDeployment instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMaxSurge(instance.getMaxSurge());

            fluent.withMaxUnavailable(instance.getMaxUnavailable());

            this.validationEnabled = validationEnabled; 
    }
    public V1RollingUpdateDeploymentBuilder(V1RollingUpdateDeployment instance){
            this(instance,true);
    }
    public V1RollingUpdateDeploymentBuilder(V1RollingUpdateDeployment instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMaxSurge(instance.getMaxSurge());

            this.withMaxUnavailable(instance.getMaxUnavailable());

            this.validationEnabled = validationEnabled; 
    }

    public V1RollingUpdateDeployment build(){
            V1RollingUpdateDeployment buildable = new V1RollingUpdateDeployment();
            buildable.setMaxSurge(fluent.getMaxSurge());
            buildable.setMaxUnavailable(fluent.getMaxUnavailable());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1RollingUpdateDeploymentBuilder that = (V1RollingUpdateDeploymentBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
