package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1PodTemplateSpecBuilder extends V1PodTemplateSpecFluentImpl<V1PodTemplateSpecBuilder> implements VisitableBuilder<V1PodTemplateSpec,V1PodTemplateSpecBuilder>{

    V1PodTemplateSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1PodTemplateSpecBuilder(){
            this(true);
    }
    public V1PodTemplateSpecBuilder(Boolean validationEnabled){
            this(new V1PodTemplateSpec(), validationEnabled);
    }
    public V1PodTemplateSpecBuilder(V1PodTemplateSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1PodTemplateSpecBuilder(V1PodTemplateSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1PodTemplateSpec(), validationEnabled);
    }
    public V1PodTemplateSpecBuilder(V1PodTemplateSpecFluent<?> fluent,V1PodTemplateSpec instance){
            this(fluent, instance, true);
    }
    public V1PodTemplateSpecBuilder(V1PodTemplateSpecFluent<?> fluent,V1PodTemplateSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }
    public V1PodTemplateSpecBuilder(V1PodTemplateSpec instance){
            this(instance,true);
    }
    public V1PodTemplateSpecBuilder(V1PodTemplateSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }

    public V1PodTemplateSpec build(){
            V1PodTemplateSpec buildable = new V1PodTemplateSpec();
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1PodTemplateSpecBuilder that = (V1PodTemplateSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
