package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1PodSecurityContextBuilder extends V1PodSecurityContextFluentImpl<V1PodSecurityContextBuilder> implements VisitableBuilder<V1PodSecurityContext,V1PodSecurityContextBuilder>{

    V1PodSecurityContextFluent<?> fluent;
    Boolean validationEnabled;

    public V1PodSecurityContextBuilder(){
            this(true);
    }
    public V1PodSecurityContextBuilder(Boolean validationEnabled){
            this(new V1PodSecurityContext(), validationEnabled);
    }
    public V1PodSecurityContextBuilder(V1PodSecurityContextFluent<?> fluent){
            this(fluent, true);
    }
    public V1PodSecurityContextBuilder(V1PodSecurityContextFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1PodSecurityContext(), validationEnabled);
    }
    public V1PodSecurityContextBuilder(V1PodSecurityContextFluent<?> fluent,V1PodSecurityContext instance){
            this(fluent, instance, true);
    }
    public V1PodSecurityContextBuilder(V1PodSecurityContextFluent<?> fluent,V1PodSecurityContext instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFsGroup(instance.getFsGroup());

            fluent.withRunAsGroup(instance.getRunAsGroup());

            fluent.withRunAsNonRoot(instance.getRunAsNonRoot());

            fluent.withRunAsUser(instance.getRunAsUser());

            fluent.withSeLinuxOptions(instance.getSeLinuxOptions());

            fluent.withSupplementalGroups(instance.getSupplementalGroups());

            fluent.withSysctls(instance.getSysctls());

            fluent.withWindowsOptions(instance.getWindowsOptions());

            this.validationEnabled = validationEnabled; 
    }
    public V1PodSecurityContextBuilder(V1PodSecurityContext instance){
            this(instance,true);
    }
    public V1PodSecurityContextBuilder(V1PodSecurityContext instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFsGroup(instance.getFsGroup());

            this.withRunAsGroup(instance.getRunAsGroup());

            this.withRunAsNonRoot(instance.getRunAsNonRoot());

            this.withRunAsUser(instance.getRunAsUser());

            this.withSeLinuxOptions(instance.getSeLinuxOptions());

            this.withSupplementalGroups(instance.getSupplementalGroups());

            this.withSysctls(instance.getSysctls());

            this.withWindowsOptions(instance.getWindowsOptions());

            this.validationEnabled = validationEnabled; 
    }

    public V1PodSecurityContext build(){
            V1PodSecurityContext buildable = new V1PodSecurityContext();
            buildable.setFsGroup(fluent.getFsGroup());
            buildable.setRunAsGroup(fluent.getRunAsGroup());
            buildable.setRunAsNonRoot(fluent.isRunAsNonRoot());
            buildable.setRunAsUser(fluent.getRunAsUser());
            buildable.setSeLinuxOptions(fluent.getSeLinuxOptions());
            buildable.setSupplementalGroups(fluent.getSupplementalGroups());
            buildable.setSysctls(fluent.getSysctls());
            buildable.setWindowsOptions(fluent.getWindowsOptions());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1PodSecurityContextBuilder that = (V1PodSecurityContextBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
