package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1PersistentVolumeListFluent<A extends V1PersistentVolumeListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,V1PersistentVolume item);
    public A setToItems(int index,V1PersistentVolume item);
    public A addToItems(V1PersistentVolume... items);
    public A addAllToItems(Collection<V1PersistentVolume> items);
    public A removeFromItems(V1PersistentVolume... items);
    public A removeAllFromItems(Collection<V1PersistentVolume> items);
    public A removeMatchingFromItems(io.kubernetes.client.fluent.Predicate<V1PersistentVolumeBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<V1PersistentVolume> getItems();
    public List<V1PersistentVolume> buildItems();
    public V1PersistentVolume buildItem(int index);
    public V1PersistentVolume buildFirstItem();
    public V1PersistentVolume buildLastItem();
    public V1PersistentVolume buildMatchingItem(io.kubernetes.client.fluent.Predicate<V1PersistentVolumeBuilder> predicate);
    public Boolean hasMatchingItem(io.kubernetes.client.fluent.Predicate<V1PersistentVolumeBuilder> predicate);
    public A withItems(List<V1PersistentVolume> items);
    public A withItems(V1PersistentVolume... items);
    public Boolean hasItems();
    public V1PersistentVolumeListFluent.ItemsNested<A> addNewItem();
    public V1PersistentVolumeListFluent.ItemsNested<A> addNewItemLike(V1PersistentVolume item);
    public V1PersistentVolumeListFluent.ItemsNested<A> setNewItemLike(int index,V1PersistentVolume item);
    public V1PersistentVolumeListFluent.ItemsNested<A> editItem(int index);
    public V1PersistentVolumeListFluent.ItemsNested<A> editFirstItem();
    public V1PersistentVolumeListFluent.ItemsNested<A> editLastItem();
    public V1PersistentVolumeListFluent.ItemsNested<A> editMatchingItem(io.kubernetes.client.fluent.Predicate<V1PersistentVolumeBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ListMeta getMetadata();
    public V1ListMeta buildMetadata();
    public A withMetadata(V1ListMeta metadata);
    public Boolean hasMetadata();
    public V1PersistentVolumeListFluent.MetadataNested<A> withNewMetadata();
    public V1PersistentVolumeListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item);
    public V1PersistentVolumeListFluent.MetadataNested<A> editMetadata();
    public V1PersistentVolumeListFluent.MetadataNested<A> editOrNewMetadata();
    public V1PersistentVolumeListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item);

    public interface ItemsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1PersistentVolumeFluent<V1PersistentVolumeListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ListMetaFluent<V1PersistentVolumeListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
