package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1NonResourceRuleBuilder extends V1NonResourceRuleFluentImpl<V1NonResourceRuleBuilder> implements VisitableBuilder<V1NonResourceRule,V1NonResourceRuleBuilder>{

    V1NonResourceRuleFluent<?> fluent;
    Boolean validationEnabled;

    public V1NonResourceRuleBuilder(){
            this(true);
    }
    public V1NonResourceRuleBuilder(Boolean validationEnabled){
            this(new V1NonResourceRule(), validationEnabled);
    }
    public V1NonResourceRuleBuilder(V1NonResourceRuleFluent<?> fluent){
            this(fluent, true);
    }
    public V1NonResourceRuleBuilder(V1NonResourceRuleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1NonResourceRule(), validationEnabled);
    }
    public V1NonResourceRuleBuilder(V1NonResourceRuleFluent<?> fluent,V1NonResourceRule instance){
            this(fluent, instance, true);
    }
    public V1NonResourceRuleBuilder(V1NonResourceRuleFluent<?> fluent,V1NonResourceRule instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNonResourceURLs(instance.getNonResourceURLs());

            fluent.withVerbs(instance.getVerbs());

            this.validationEnabled = validationEnabled; 
    }
    public V1NonResourceRuleBuilder(V1NonResourceRule instance){
            this(instance,true);
    }
    public V1NonResourceRuleBuilder(V1NonResourceRule instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNonResourceURLs(instance.getNonResourceURLs());

            this.withVerbs(instance.getVerbs());

            this.validationEnabled = validationEnabled; 
    }

    public V1NonResourceRule build(){
            V1NonResourceRule buildable = new V1NonResourceRule();
            buildable.setNonResourceURLs(fluent.getNonResourceURLs());
            buildable.setVerbs(fluent.getVerbs());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1NonResourceRuleBuilder that = (V1NonResourceRuleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
