package io.kubernetes.client.openapi.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import org.joda.time.DateTime;

public class V1ManagedFieldsEntryFluentImpl<A extends V1ManagedFieldsEntryFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1ManagedFieldsEntryFluent<A>{

    private String apiVersion;
    private String fieldsType;
    private Object fieldsV1;
    private String manager;
    private String operation;
    private DateTime time;

    public V1ManagedFieldsEntryFluentImpl(){
    }
    public V1ManagedFieldsEntryFluentImpl(V1ManagedFieldsEntry instance){
            this.withApiVersion(instance.getApiVersion());

            this.withFieldsType(instance.getFieldsType());

            this.withFieldsV1(instance.getFieldsV1());

            this.withManager(instance.getManager());

            this.withOperation(instance.getOperation());

            this.withTime(instance.getTime());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getFieldsType(){
            return this.fieldsType;
    }

    public A withFieldsType(String fieldsType){
            this.fieldsType=fieldsType; return (A) this;
    }

    public Boolean hasFieldsType(){
            return this.fieldsType != null;
    }

    public A withNewFieldsType(String arg1){
            return (A)withFieldsType(new String(arg1));
    }

    public A withNewFieldsType(StringBuilder arg1){
            return (A)withFieldsType(new String(arg1));
    }

    public A withNewFieldsType(StringBuffer arg1){
            return (A)withFieldsType(new String(arg1));
    }

    public Object getFieldsV1(){
            return this.fieldsV1;
    }

    public A withFieldsV1(Object fieldsV1){
            this.fieldsV1=fieldsV1; return (A) this;
    }

    public Boolean hasFieldsV1(){
            return this.fieldsV1 != null;
    }

    public String getManager(){
            return this.manager;
    }

    public A withManager(String manager){
            this.manager=manager; return (A) this;
    }

    public Boolean hasManager(){
            return this.manager != null;
    }

    public A withNewManager(String arg1){
            return (A)withManager(new String(arg1));
    }

    public A withNewManager(StringBuilder arg1){
            return (A)withManager(new String(arg1));
    }

    public A withNewManager(StringBuffer arg1){
            return (A)withManager(new String(arg1));
    }

    public String getOperation(){
            return this.operation;
    }

    public A withOperation(String operation){
            this.operation=operation; return (A) this;
    }

    public Boolean hasOperation(){
            return this.operation != null;
    }

    public A withNewOperation(String arg1){
            return (A)withOperation(new String(arg1));
    }

    public A withNewOperation(StringBuilder arg1){
            return (A)withOperation(new String(arg1));
    }

    public A withNewOperation(StringBuffer arg1){
            return (A)withOperation(new String(arg1));
    }

    public DateTime getTime(){
            return this.time;
    }

    public A withTime(DateTime time){
            this.time=time; return (A) this;
    }

    public Boolean hasTime(){
            return this.time != null;
    }

    public A withNewTime(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withTime(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewTime(Object arg0){
            return (A)withTime(new DateTime(arg0));
    }

    public A withNewTime(long arg0){
            return (A)withTime(new DateTime(arg0));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1ManagedFieldsEntryFluentImpl that = (V1ManagedFieldsEntryFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (fieldsType != null ? !fieldsType.equals(that.fieldsType) :that.fieldsType != null) return false;
            if (fieldsV1 != null &&fieldsV1 != this ? !fieldsV1.equals(that.fieldsV1) :that.fieldsV1 != null &&fieldsV1 != this ) return false;

            if (manager != null ? !manager.equals(that.manager) :that.manager != null) return false;
            if (operation != null ? !operation.equals(that.operation) :that.operation != null) return false;
            if (time != null ? !time.equals(that.time) :that.time != null) return false;
            return true;
    }




}
