package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1LoadBalancerStatusBuilder extends V1LoadBalancerStatusFluentImpl<V1LoadBalancerStatusBuilder> implements VisitableBuilder<V1LoadBalancerStatus,V1LoadBalancerStatusBuilder>{

    V1LoadBalancerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1LoadBalancerStatusBuilder(){
            this(true);
    }
    public V1LoadBalancerStatusBuilder(Boolean validationEnabled){
            this(new V1LoadBalancerStatus(), validationEnabled);
    }
    public V1LoadBalancerStatusBuilder(V1LoadBalancerStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1LoadBalancerStatusBuilder(V1LoadBalancerStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1LoadBalancerStatus(), validationEnabled);
    }
    public V1LoadBalancerStatusBuilder(V1LoadBalancerStatusFluent<?> fluent,V1LoadBalancerStatus instance){
            this(fluent, instance, true);
    }
    public V1LoadBalancerStatusBuilder(V1LoadBalancerStatusFluent<?> fluent,V1LoadBalancerStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withIngress(instance.getIngress());

            this.validationEnabled = validationEnabled; 
    }
    public V1LoadBalancerStatusBuilder(V1LoadBalancerStatus instance){
            this(instance,true);
    }
    public V1LoadBalancerStatusBuilder(V1LoadBalancerStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withIngress(instance.getIngress());

            this.validationEnabled = validationEnabled; 
    }

    public V1LoadBalancerStatus build(){
            V1LoadBalancerStatus buildable = new V1LoadBalancerStatus();
            buildable.setIngress(fluent.getIngress());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1LoadBalancerStatusBuilder that = (V1LoadBalancerStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
