package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1InitializerBuilder extends V1InitializerFluentImpl<V1InitializerBuilder> implements VisitableBuilder<V1Initializer,V1InitializerBuilder>{

    V1InitializerFluent<?> fluent;
    Boolean validationEnabled;

    public V1InitializerBuilder(){
            this(true);
    }
    public V1InitializerBuilder(Boolean validationEnabled){
            this(new V1Initializer(), validationEnabled);
    }
    public V1InitializerBuilder(V1InitializerFluent<?> fluent){
            this(fluent, true);
    }
    public V1InitializerBuilder(V1InitializerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1Initializer(), validationEnabled);
    }
    public V1InitializerBuilder(V1InitializerFluent<?> fluent,V1Initializer instance){
            this(fluent, instance, true);
    }
    public V1InitializerBuilder(V1InitializerFluent<?> fluent,V1Initializer instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }
    public V1InitializerBuilder(V1Initializer instance){
            this(instance,true);
    }
    public V1InitializerBuilder(V1Initializer instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }

    public V1Initializer build(){
            V1Initializer buildable = new V1Initializer();
            buildable.setName(fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1InitializerBuilder that = (V1InitializerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
