package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1ISCSIPersistentVolumeSourceFluent<A extends V1ISCSIPersistentVolumeSourceFluent<A>> extends Fluent<A>{


    public Boolean isChapAuthDiscovery();
    public A withChapAuthDiscovery(Boolean chapAuthDiscovery);
    public Boolean hasChapAuthDiscovery();
    public A withNewChapAuthDiscovery(String arg1);
    public A withNewChapAuthDiscovery(boolean arg1);
    public Boolean isChapAuthSession();
    public A withChapAuthSession(Boolean chapAuthSession);
    public Boolean hasChapAuthSession();
    public A withNewChapAuthSession(String arg1);
    public A withNewChapAuthSession(boolean arg1);
    public String getFsType();
    public A withFsType(String fsType);
    public Boolean hasFsType();
    public A withNewFsType(String arg1);
    public A withNewFsType(StringBuilder arg1);
    public A withNewFsType(StringBuffer arg1);
    public String getInitiatorName();
    public A withInitiatorName(String initiatorName);
    public Boolean hasInitiatorName();
    public A withNewInitiatorName(String arg1);
    public A withNewInitiatorName(StringBuilder arg1);
    public A withNewInitiatorName(StringBuffer arg1);
    public String getIqn();
    public A withIqn(String iqn);
    public Boolean hasIqn();
    public A withNewIqn(String arg1);
    public A withNewIqn(StringBuilder arg1);
    public A withNewIqn(StringBuffer arg1);
    public String getIscsiInterface();
    public A withIscsiInterface(String iscsiInterface);
    public Boolean hasIscsiInterface();
    public A withNewIscsiInterface(String arg1);
    public A withNewIscsiInterface(StringBuilder arg1);
    public A withNewIscsiInterface(StringBuffer arg1);
    public Integer getLun();
    public A withLun(Integer lun);
    public Boolean hasLun();
    public A addToPortals(int index,String item);
    public A setToPortals(int index,String item);
    public A addToPortals(String... items);
    public A addAllToPortals(Collection<String> items);
    public A removeFromPortals(String... items);
    public A removeAllFromPortals(Collection<String> items);
    public List<String> getPortals();
    public String getPortal(int index);
    public String getFirstPortal();
    public String getLastPortal();
    public String getMatchingPortal(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingPortal(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withPortals(List<String> portals);
    public A withPortals(String... portals);
    public Boolean hasPortals();
    public A addNewPortal(String arg1);
    public A addNewPortal(StringBuilder arg1);
    public A addNewPortal(StringBuffer arg1);
    public Boolean isReadOnly();
    public A withReadOnly(Boolean readOnly);
    public Boolean hasReadOnly();
    public A withNewReadOnly(String arg1);
    public A withNewReadOnly(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildSecretRef instead.
 * @return The buildable object.
 */
@Deprecated public V1SecretReference getSecretRef();
    public V1SecretReference buildSecretRef();
    public A withSecretRef(V1SecretReference secretRef);
    public Boolean hasSecretRef();
    public V1ISCSIPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef();
    public V1ISCSIPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(V1SecretReference item);
    public V1ISCSIPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef();
    public V1ISCSIPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef();
    public V1ISCSIPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(V1SecretReference item);
    public String getTargetPortal();
    public A withTargetPortal(String targetPortal);
    public Boolean hasTargetPortal();
    public A withNewTargetPortal(String arg1);
    public A withNewTargetPortal(StringBuilder arg1);
    public A withNewTargetPortal(StringBuffer arg1);

    public interface SecretRefNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1SecretReferenceFluent<V1ISCSIPersistentVolumeSourceFluent.SecretRefNested<N>>{

        
    public N and();    public N endSecretRef();
}


}
