package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.lang.StringBuilder;
import io.kubernetes.client.fluent.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.StringBuffer;

public class V1EphemeralContainerFluentImpl<A extends V1EphemeralContainerFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1EphemeralContainerFluent<A>{

    private List<String> args;
    private List<String> command;
    private List<V1EnvVarBuilder> env;
    private List<V1EnvFromSourceBuilder> envFrom;
    private String image;
    private String imagePullPolicy;
    private V1LifecycleBuilder lifecycle;
    private V1ProbeBuilder livenessProbe;
    private String name;
    private List<V1ContainerPortBuilder> ports;
    private V1ProbeBuilder readinessProbe;
    private V1ResourceRequirementsBuilder resources;
    private V1SecurityContextBuilder securityContext;
    private V1ProbeBuilder startupProbe;
    private Boolean stdin;
    private Boolean stdinOnce;
    private String targetContainerName;
    private String terminationMessagePath;
    private String terminationMessagePolicy;
    private Boolean tty;
    private List<V1VolumeDeviceBuilder> volumeDevices;
    private List<V1VolumeMountBuilder> volumeMounts;
    private String workingDir;

    public V1EphemeralContainerFluentImpl(){
    }
    public V1EphemeralContainerFluentImpl(V1EphemeralContainer instance){
            this.withArgs(instance.getArgs());

            this.withCommand(instance.getCommand());

            this.withEnv(instance.getEnv());

            this.withEnvFrom(instance.getEnvFrom());

            this.withImage(instance.getImage());

            this.withImagePullPolicy(instance.getImagePullPolicy());

            this.withLifecycle(instance.getLifecycle());

            this.withLivenessProbe(instance.getLivenessProbe());

            this.withName(instance.getName());

            this.withPorts(instance.getPorts());

            this.withReadinessProbe(instance.getReadinessProbe());

            this.withResources(instance.getResources());

            this.withSecurityContext(instance.getSecurityContext());

            this.withStartupProbe(instance.getStartupProbe());

            this.withStdin(instance.getStdin());

            this.withStdinOnce(instance.getStdinOnce());

            this.withTargetContainerName(instance.getTargetContainerName());

            this.withTerminationMessagePath(instance.getTerminationMessagePath());

            this.withTerminationMessagePolicy(instance.getTerminationMessagePolicy());

            this.withTty(instance.getTty());

            this.withVolumeDevices(instance.getVolumeDevices());

            this.withVolumeMounts(instance.getVolumeMounts());

            this.withWorkingDir(instance.getWorkingDir());

    }

    public A addToArgs(int index,String item){
            if (this.args == null) {this.args = new ArrayList<String>();}
            this.args.add(index, item);
            return (A)this;
    }

    public A setToArgs(int index,String item){
            if (this.args == null) {this.args = new ArrayList<String>();}
            this.args.set(index, item); return (A)this;
    }

    public A addToArgs(String... items){
            if (this.args == null) {this.args = new ArrayList<String>();}
            for (String item : items) {this.args.add(item);} return (A)this;
    }

    public A addAllToArgs(Collection<String> items){
            if (this.args == null) {this.args = new ArrayList<String>();}
            for (String item : items) {this.args.add(item);} return (A)this;
    }

    public A removeFromArgs(String... items){
            for (String item : items) {if (this.args!= null){ this.args.remove(item);}} return (A)this;
    }

    public A removeAllFromArgs(Collection<String> items){
            for (String item : items) {if (this.args!= null){ this.args.remove(item);}} return (A)this;
    }

    public List<String> getArgs(){
            return this.args;
    }

    public String getArg(int index){
            return this.args.get(index);
    }

    public String getFirstArg(){
            return this.args.get(0);
    }

    public String getLastArg(){
            return this.args.get(args.size() - 1);
    }

    public String getMatchingArg(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: args) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingArg(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: args) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withArgs(List<String> args){
            if (this.args != null) { _visitables.get("args").removeAll(this.args);}
            if (args != null) {this.args = new ArrayList<String>(); for (String item : args){this.addToArgs(item);}} else { this.args = null;} return (A) this;
    }

    public A withArgs(String... args){
            if (this.args != null) {this.args.clear();}
            if (args != null) {for (String item :args){ this.addToArgs(item);}} return (A) this;
    }

    public Boolean hasArgs(){
            return args != null && !args.isEmpty();
    }

    public A addNewArg(String arg1){
            return (A)addToArgs(new String(arg1));
    }

    public A addNewArg(StringBuilder arg1){
            return (A)addToArgs(new String(arg1));
    }

    public A addNewArg(StringBuffer arg1){
            return (A)addToArgs(new String(arg1));
    }

    public A addToCommand(int index,String item){
            if (this.command == null) {this.command = new ArrayList<String>();}
            this.command.add(index, item);
            return (A)this;
    }

    public A setToCommand(int index,String item){
            if (this.command == null) {this.command = new ArrayList<String>();}
            this.command.set(index, item); return (A)this;
    }

    public A addToCommand(String... items){
            if (this.command == null) {this.command = new ArrayList<String>();}
            for (String item : items) {this.command.add(item);} return (A)this;
    }

    public A addAllToCommand(Collection<String> items){
            if (this.command == null) {this.command = new ArrayList<String>();}
            for (String item : items) {this.command.add(item);} return (A)this;
    }

    public A removeFromCommand(String... items){
            for (String item : items) {if (this.command!= null){ this.command.remove(item);}} return (A)this;
    }

    public A removeAllFromCommand(Collection<String> items){
            for (String item : items) {if (this.command!= null){ this.command.remove(item);}} return (A)this;
    }

    public List<String> getCommand(){
            return this.command;
    }

    public String getCommand(int index){
            return this.command.get(index);
    }

    public String getFirstCommand(){
            return this.command.get(0);
    }

    public String getLastCommand(){
            return this.command.get(command.size() - 1);
    }

    public String getMatchingCommand(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: command) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingCommand(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: command) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withCommand(List<String> command){
            if (this.command != null) { _visitables.get("command").removeAll(this.command);}
            if (command != null) {this.command = new ArrayList<String>(); for (String item : command){this.addToCommand(item);}} else { this.command = null;} return (A) this;
    }

    public A withCommand(String... command){
            if (this.command != null) {this.command.clear();}
            if (command != null) {for (String item :command){ this.addToCommand(item);}} return (A) this;
    }

    public Boolean hasCommand(){
            return command != null && !command.isEmpty();
    }

    public A addNewCommand(String arg1){
            return (A)addToCommand(new String(arg1));
    }

    public A addNewCommand(StringBuilder arg1){
            return (A)addToCommand(new String(arg1));
    }

    public A addNewCommand(StringBuffer arg1){
            return (A)addToCommand(new String(arg1));
    }

    public A addToEnv(int index,V1EnvVar item){
            if (this.env == null) {this.env = new ArrayList<V1EnvVarBuilder>();}
            V1EnvVarBuilder builder = new V1EnvVarBuilder(item);_visitables.get("env").add(index >= 0 ? index : _visitables.get("env").size(), builder);this.env.add(index >= 0 ? index : env.size(), builder); return (A)this;
    }

    public A setToEnv(int index,V1EnvVar item){
            if (this.env == null) {this.env = new ArrayList<V1EnvVarBuilder>();}
            V1EnvVarBuilder builder = new V1EnvVarBuilder(item);
            if (index < 0 || index >= _visitables.get("env").size()) { _visitables.get("env").add(builder); } else { _visitables.get("env").set(index, builder);}
            if (index < 0 || index >= env.size()) { env.add(builder); } else { env.set(index, builder);}
             return (A)this;
    }

    public A addToEnv(V1EnvVar... items){
            if (this.env == null) {this.env = new ArrayList<V1EnvVarBuilder>();}
            for (V1EnvVar item : items) {V1EnvVarBuilder builder = new V1EnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
    }

    public A addAllToEnv(Collection<V1EnvVar> items){
            if (this.env == null) {this.env = new ArrayList<V1EnvVarBuilder>();}
            for (V1EnvVar item : items) {V1EnvVarBuilder builder = new V1EnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
    }

    public A removeFromEnv(V1EnvVar... items){
            for (V1EnvVar item : items) {V1EnvVarBuilder builder = new V1EnvVarBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
    }

    public A removeAllFromEnv(Collection<V1EnvVar> items){
            for (V1EnvVar item : items) {V1EnvVarBuilder builder = new V1EnvVarBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEnv(io.kubernetes.client.fluent.Predicate<V1EnvVarBuilder> predicate){
            if (env == null) return (A) this;
            final Iterator<V1EnvVarBuilder> each = env.iterator();
            final List visitables = _visitables.get("env");
            while (each.hasNext()) {
              V1EnvVarBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildEnv instead.
 * @return The buildable object.
 */
@Deprecated public List<V1EnvVar> getEnv(){
            return build(env);
    }

    public List<V1EnvVar> buildEnv(){
            return build(env);
    }

    public V1EnvVar buildEnv(int index){
            return this.env.get(index).build();
    }

    public V1EnvVar buildFirstEnv(){
            return this.env.get(0).build();
    }

    public V1EnvVar buildLastEnv(){
            return this.env.get(env.size() - 1).build();
    }

    public V1EnvVar buildMatchingEnv(io.kubernetes.client.fluent.Predicate<V1EnvVarBuilder> predicate){
            for (V1EnvVarBuilder item: env) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingEnv(io.kubernetes.client.fluent.Predicate<V1EnvVarBuilder> predicate){
            for (V1EnvVarBuilder item: env) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withEnv(List<V1EnvVar> env){
            if (this.env != null) { _visitables.get("env").removeAll(this.env);}
            if (env != null) {this.env = new ArrayList<V1EnvVarBuilder>(); for (V1EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
    }

    public A withEnv(V1EnvVar... env){
            if (this.env != null) {this.env.clear();}
            if (env != null) {for (V1EnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }

    public Boolean hasEnv(){
            return env != null && !env.isEmpty();
    }

    public V1EphemeralContainerFluent.EnvNested<A> addNewEnv(){
            return new EnvNestedImpl();
    }

    public V1EphemeralContainerFluent.EnvNested<A> addNewEnvLike(V1EnvVar item){
            return new EnvNestedImpl(-1, item);
    }

    public V1EphemeralContainerFluent.EnvNested<A> setNewEnvLike(int index,V1EnvVar item){
            return new EnvNestedImpl(index, item);
    }

    public V1EphemeralContainerFluent.EnvNested<A> editEnv(int index){
            if (env.size() <= index) throw new RuntimeException("Can't edit env. Index exceeds size.");
            return setNewEnvLike(index, buildEnv(index));
    }

    public V1EphemeralContainerFluent.EnvNested<A> editFirstEnv(){
            if (env.size() == 0) throw new RuntimeException("Can't edit first env. The list is empty.");
            return setNewEnvLike(0, buildEnv(0));
    }

    public V1EphemeralContainerFluent.EnvNested<A> editLastEnv(){
            int index = env.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last env. The list is empty.");
            return setNewEnvLike(index, buildEnv(index));
    }

    public V1EphemeralContainerFluent.EnvNested<A> editMatchingEnv(io.kubernetes.client.fluent.Predicate<V1EnvVarBuilder> predicate){
            int index = -1;
            for (int i=0;i<env.size();i++) { 
            if (predicate.apply(env.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching env. No match found.");
            return setNewEnvLike(index, buildEnv(index));
    }

    public A addToEnvFrom(int index,V1EnvFromSource item){
            if (this.envFrom == null) {this.envFrom = new ArrayList<V1EnvFromSourceBuilder>();}
            V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);_visitables.get("envFrom").add(index >= 0 ? index : _visitables.get("envFrom").size(), builder);this.envFrom.add(index >= 0 ? index : envFrom.size(), builder); return (A)this;
    }

    public A setToEnvFrom(int index,V1EnvFromSource item){
            if (this.envFrom == null) {this.envFrom = new ArrayList<V1EnvFromSourceBuilder>();}
            V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);
            if (index < 0 || index >= _visitables.get("envFrom").size()) { _visitables.get("envFrom").add(builder); } else { _visitables.get("envFrom").set(index, builder);}
            if (index < 0 || index >= envFrom.size()) { envFrom.add(builder); } else { envFrom.set(index, builder);}
             return (A)this;
    }

    public A addToEnvFrom(V1EnvFromSource... items){
            if (this.envFrom == null) {this.envFrom = new ArrayList<V1EnvFromSourceBuilder>();}
            for (V1EnvFromSource item : items) {V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);_visitables.get("envFrom").add(builder);this.envFrom.add(builder);} return (A)this;
    }

    public A addAllToEnvFrom(Collection<V1EnvFromSource> items){
            if (this.envFrom == null) {this.envFrom = new ArrayList<V1EnvFromSourceBuilder>();}
            for (V1EnvFromSource item : items) {V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);_visitables.get("envFrom").add(builder);this.envFrom.add(builder);} return (A)this;
    }

    public A removeFromEnvFrom(V1EnvFromSource... items){
            for (V1EnvFromSource item : items) {V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);_visitables.get("envFrom").remove(builder);if (this.envFrom != null) {this.envFrom.remove(builder);}} return (A)this;
    }

    public A removeAllFromEnvFrom(Collection<V1EnvFromSource> items){
            for (V1EnvFromSource item : items) {V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);_visitables.get("envFrom").remove(builder);if (this.envFrom != null) {this.envFrom.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEnvFrom(io.kubernetes.client.fluent.Predicate<V1EnvFromSourceBuilder> predicate){
            if (envFrom == null) return (A) this;
            final Iterator<V1EnvFromSourceBuilder> each = envFrom.iterator();
            final List visitables = _visitables.get("envFrom");
            while (each.hasNext()) {
              V1EnvFromSourceBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildEnvFrom instead.
 * @return The buildable object.
 */
@Deprecated public List<V1EnvFromSource> getEnvFrom(){
            return build(envFrom);
    }

    public List<V1EnvFromSource> buildEnvFrom(){
            return build(envFrom);
    }

    public V1EnvFromSource buildEnvFrom(int index){
            return this.envFrom.get(index).build();
    }

    public V1EnvFromSource buildFirstEnvFrom(){
            return this.envFrom.get(0).build();
    }

    public V1EnvFromSource buildLastEnvFrom(){
            return this.envFrom.get(envFrom.size() - 1).build();
    }

    public V1EnvFromSource buildMatchingEnvFrom(io.kubernetes.client.fluent.Predicate<V1EnvFromSourceBuilder> predicate){
            for (V1EnvFromSourceBuilder item: envFrom) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingEnvFrom(io.kubernetes.client.fluent.Predicate<V1EnvFromSourceBuilder> predicate){
            for (V1EnvFromSourceBuilder item: envFrom) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withEnvFrom(List<V1EnvFromSource> envFrom){
            if (this.envFrom != null) { _visitables.get("envFrom").removeAll(this.envFrom);}
            if (envFrom != null) {this.envFrom = new ArrayList<V1EnvFromSourceBuilder>(); for (V1EnvFromSource item : envFrom){this.addToEnvFrom(item);}} else { this.envFrom = null;} return (A) this;
    }

    public A withEnvFrom(V1EnvFromSource... envFrom){
            if (this.envFrom != null) {this.envFrom.clear();}
            if (envFrom != null) {for (V1EnvFromSource item :envFrom){ this.addToEnvFrom(item);}} return (A) this;
    }

    public Boolean hasEnvFrom(){
            return envFrom != null && !envFrom.isEmpty();
    }

    public V1EphemeralContainerFluent.EnvFromNested<A> addNewEnvFrom(){
            return new EnvFromNestedImpl();
    }

    public V1EphemeralContainerFluent.EnvFromNested<A> addNewEnvFromLike(V1EnvFromSource item){
            return new EnvFromNestedImpl(-1, item);
    }

    public V1EphemeralContainerFluent.EnvFromNested<A> setNewEnvFromLike(int index,V1EnvFromSource item){
            return new EnvFromNestedImpl(index, item);
    }

    public V1EphemeralContainerFluent.EnvFromNested<A> editEnvFrom(int index){
            if (envFrom.size() <= index) throw new RuntimeException("Can't edit envFrom. Index exceeds size.");
            return setNewEnvFromLike(index, buildEnvFrom(index));
    }

    public V1EphemeralContainerFluent.EnvFromNested<A> editFirstEnvFrom(){
            if (envFrom.size() == 0) throw new RuntimeException("Can't edit first envFrom. The list is empty.");
            return setNewEnvFromLike(0, buildEnvFrom(0));
    }

    public V1EphemeralContainerFluent.EnvFromNested<A> editLastEnvFrom(){
            int index = envFrom.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last envFrom. The list is empty.");
            return setNewEnvFromLike(index, buildEnvFrom(index));
    }

    public V1EphemeralContainerFluent.EnvFromNested<A> editMatchingEnvFrom(io.kubernetes.client.fluent.Predicate<V1EnvFromSourceBuilder> predicate){
            int index = -1;
            for (int i=0;i<envFrom.size();i++) { 
            if (predicate.apply(envFrom.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching envFrom. No match found.");
            return setNewEnvFromLike(index, buildEnvFrom(index));
    }

    public String getImage(){
            return this.image;
    }

    public A withImage(String image){
            this.image=image; return (A) this;
    }

    public Boolean hasImage(){
            return this.image != null;
    }

    public A withNewImage(String arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuilder arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1){
            return (A)withImage(new String(arg1));
    }

    public String getImagePullPolicy(){
            return this.imagePullPolicy;
    }

    public A withImagePullPolicy(String imagePullPolicy){
            this.imagePullPolicy=imagePullPolicy; return (A) this;
    }

    public Boolean hasImagePullPolicy(){
            return this.imagePullPolicy != null;
    }

    public A withNewImagePullPolicy(String arg1){
            return (A)withImagePullPolicy(new String(arg1));
    }

    public A withNewImagePullPolicy(StringBuilder arg1){
            return (A)withImagePullPolicy(new String(arg1));
    }

    public A withNewImagePullPolicy(StringBuffer arg1){
            return (A)withImagePullPolicy(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildLifecycle instead.
 * @return The buildable object.
 */
@Deprecated public V1Lifecycle getLifecycle(){
            return this.lifecycle!=null?this.lifecycle.build():null;
    }

    public V1Lifecycle buildLifecycle(){
            return this.lifecycle!=null?this.lifecycle.build():null;
    }

    public A withLifecycle(V1Lifecycle lifecycle){
            _visitables.get("lifecycle").remove(this.lifecycle);
            if (lifecycle!=null){ this.lifecycle= new V1LifecycleBuilder(lifecycle); _visitables.get("lifecycle").add(this.lifecycle);} return (A) this;
    }

    public Boolean hasLifecycle(){
            return this.lifecycle != null;
    }

    public V1EphemeralContainerFluent.LifecycleNested<A> withNewLifecycle(){
            return new LifecycleNestedImpl();
    }

    public V1EphemeralContainerFluent.LifecycleNested<A> withNewLifecycleLike(V1Lifecycle item){
            return new LifecycleNestedImpl(item);
    }

    public V1EphemeralContainerFluent.LifecycleNested<A> editLifecycle(){
            return withNewLifecycleLike(getLifecycle());
    }

    public V1EphemeralContainerFluent.LifecycleNested<A> editOrNewLifecycle(){
            return withNewLifecycleLike(getLifecycle() != null ? getLifecycle(): new V1LifecycleBuilder().build());
    }

    public V1EphemeralContainerFluent.LifecycleNested<A> editOrNewLifecycleLike(V1Lifecycle item){
            return withNewLifecycleLike(getLifecycle() != null ? getLifecycle(): item);
    }

    
/**
 * This method has been deprecated, please use method buildLivenessProbe instead.
 * @return The buildable object.
 */
@Deprecated public V1Probe getLivenessProbe(){
            return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public V1Probe buildLivenessProbe(){
            return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public A withLivenessProbe(V1Probe livenessProbe){
            _visitables.get("livenessProbe").remove(this.livenessProbe);
            if (livenessProbe!=null){ this.livenessProbe= new V1ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} return (A) this;
    }

    public Boolean hasLivenessProbe(){
            return this.livenessProbe != null;
    }

    public V1EphemeralContainerFluent.LivenessProbeNested<A> withNewLivenessProbe(){
            return new LivenessProbeNestedImpl();
    }

    public V1EphemeralContainerFluent.LivenessProbeNested<A> withNewLivenessProbeLike(V1Probe item){
            return new LivenessProbeNestedImpl(item);
    }

    public V1EphemeralContainerFluent.LivenessProbeNested<A> editLivenessProbe(){
            return withNewLivenessProbeLike(getLivenessProbe());
    }

    public V1EphemeralContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbe(){
            return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): new V1ProbeBuilder().build());
    }

    public V1EphemeralContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(V1Probe item){
            return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): item);
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public A addToPorts(int index,V1ContainerPort item){
            if (this.ports == null) {this.ports = new ArrayList<V1ContainerPortBuilder>();}
            V1ContainerPortBuilder builder = new V1ContainerPortBuilder(item);_visitables.get("ports").add(index >= 0 ? index : _visitables.get("ports").size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
    }

    public A setToPorts(int index,V1ContainerPort item){
            if (this.ports == null) {this.ports = new ArrayList<V1ContainerPortBuilder>();}
            V1ContainerPortBuilder builder = new V1ContainerPortBuilder(item);
            if (index < 0 || index >= _visitables.get("ports").size()) { _visitables.get("ports").add(builder); } else { _visitables.get("ports").set(index, builder);}
            if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
             return (A)this;
    }

    public A addToPorts(V1ContainerPort... items){
            if (this.ports == null) {this.ports = new ArrayList<V1ContainerPortBuilder>();}
            for (V1ContainerPort item : items) {V1ContainerPortBuilder builder = new V1ContainerPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
    }

    public A addAllToPorts(Collection<V1ContainerPort> items){
            if (this.ports == null) {this.ports = new ArrayList<V1ContainerPortBuilder>();}
            for (V1ContainerPort item : items) {V1ContainerPortBuilder builder = new V1ContainerPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
    }

    public A removeFromPorts(V1ContainerPort... items){
            for (V1ContainerPort item : items) {V1ContainerPortBuilder builder = new V1ContainerPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeAllFromPorts(Collection<V1ContainerPort> items){
            for (V1ContainerPort item : items) {V1ContainerPortBuilder builder = new V1ContainerPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPorts(io.kubernetes.client.fluent.Predicate<V1ContainerPortBuilder> predicate){
            if (ports == null) return (A) this;
            final Iterator<V1ContainerPortBuilder> each = ports.iterator();
            final List visitables = _visitables.get("ports");
            while (each.hasNext()) {
              V1ContainerPortBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<V1ContainerPort> getPorts(){
            return build(ports);
    }

    public List<V1ContainerPort> buildPorts(){
            return build(ports);
    }

    public V1ContainerPort buildPort(int index){
            return this.ports.get(index).build();
    }

    public V1ContainerPort buildFirstPort(){
            return this.ports.get(0).build();
    }

    public V1ContainerPort buildLastPort(){
            return this.ports.get(ports.size() - 1).build();
    }

    public V1ContainerPort buildMatchingPort(io.kubernetes.client.fluent.Predicate<V1ContainerPortBuilder> predicate){
            for (V1ContainerPortBuilder item: ports) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingPort(io.kubernetes.client.fluent.Predicate<V1ContainerPortBuilder> predicate){
            for (V1ContainerPortBuilder item: ports) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withPorts(List<V1ContainerPort> ports){
            if (this.ports != null) { _visitables.get("ports").removeAll(this.ports);}
            if (ports != null) {this.ports = new ArrayList<V1ContainerPortBuilder>(); for (V1ContainerPort item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
    }

    public A withPorts(V1ContainerPort... ports){
            if (this.ports != null) {this.ports.clear();}
            if (ports != null) {for (V1ContainerPort item :ports){ this.addToPorts(item);}} return (A) this;
    }

    public Boolean hasPorts(){
            return ports != null && !ports.isEmpty();
    }

    public V1EphemeralContainerFluent.PortsNested<A> addNewPort(){
            return new PortsNestedImpl();
    }

    public V1EphemeralContainerFluent.PortsNested<A> addNewPortLike(V1ContainerPort item){
            return new PortsNestedImpl(-1, item);
    }

    public V1EphemeralContainerFluent.PortsNested<A> setNewPortLike(int index,V1ContainerPort item){
            return new PortsNestedImpl(index, item);
    }

    public V1EphemeralContainerFluent.PortsNested<A> editPort(int index){
            if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
            return setNewPortLike(index, buildPort(index));
    }

    public V1EphemeralContainerFluent.PortsNested<A> editFirstPort(){
            if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
            return setNewPortLike(0, buildPort(0));
    }

    public V1EphemeralContainerFluent.PortsNested<A> editLastPort(){
            int index = ports.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
            return setNewPortLike(index, buildPort(index));
    }

    public V1EphemeralContainerFluent.PortsNested<A> editMatchingPort(io.kubernetes.client.fluent.Predicate<V1ContainerPortBuilder> predicate){
            int index = -1;
            for (int i=0;i<ports.size();i++) { 
            if (predicate.apply(ports.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
            return setNewPortLike(index, buildPort(index));
    }

    
/**
 * This method has been deprecated, please use method buildReadinessProbe instead.
 * @return The buildable object.
 */
@Deprecated public V1Probe getReadinessProbe(){
            return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public V1Probe buildReadinessProbe(){
            return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public A withReadinessProbe(V1Probe readinessProbe){
            _visitables.get("readinessProbe").remove(this.readinessProbe);
            if (readinessProbe!=null){ this.readinessProbe= new V1ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} return (A) this;
    }

    public Boolean hasReadinessProbe(){
            return this.readinessProbe != null;
    }

    public V1EphemeralContainerFluent.ReadinessProbeNested<A> withNewReadinessProbe(){
            return new ReadinessProbeNestedImpl();
    }

    public V1EphemeralContainerFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(V1Probe item){
            return new ReadinessProbeNestedImpl(item);
    }

    public V1EphemeralContainerFluent.ReadinessProbeNested<A> editReadinessProbe(){
            return withNewReadinessProbeLike(getReadinessProbe());
    }

    public V1EphemeralContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbe(){
            return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): new V1ProbeBuilder().build());
    }

    public V1EphemeralContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(V1Probe item){
            return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): item);
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public V1ResourceRequirements getResources(){
            return this.resources!=null?this.resources.build():null;
    }

    public V1ResourceRequirements buildResources(){
            return this.resources!=null?this.resources.build():null;
    }

    public A withResources(V1ResourceRequirements resources){
            _visitables.get("resources").remove(this.resources);
            if (resources!=null){ this.resources= new V1ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} return (A) this;
    }

    public Boolean hasResources(){
            return this.resources != null;
    }

    public V1EphemeralContainerFluent.ResourcesNested<A> withNewResources(){
            return new ResourcesNestedImpl();
    }

    public V1EphemeralContainerFluent.ResourcesNested<A> withNewResourcesLike(V1ResourceRequirements item){
            return new ResourcesNestedImpl(item);
    }

    public V1EphemeralContainerFluent.ResourcesNested<A> editResources(){
            return withNewResourcesLike(getResources());
    }

    public V1EphemeralContainerFluent.ResourcesNested<A> editOrNewResources(){
            return withNewResourcesLike(getResources() != null ? getResources(): new V1ResourceRequirementsBuilder().build());
    }

    public V1EphemeralContainerFluent.ResourcesNested<A> editOrNewResourcesLike(V1ResourceRequirements item){
            return withNewResourcesLike(getResources() != null ? getResources(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSecurityContext instead.
 * @return The buildable object.
 */
@Deprecated public V1SecurityContext getSecurityContext(){
            return this.securityContext!=null?this.securityContext.build():null;
    }

    public V1SecurityContext buildSecurityContext(){
            return this.securityContext!=null?this.securityContext.build():null;
    }

    public A withSecurityContext(V1SecurityContext securityContext){
            _visitables.get("securityContext").remove(this.securityContext);
            if (securityContext!=null){ this.securityContext= new V1SecurityContextBuilder(securityContext); _visitables.get("securityContext").add(this.securityContext);} return (A) this;
    }

    public Boolean hasSecurityContext(){
            return this.securityContext != null;
    }

    public V1EphemeralContainerFluent.SecurityContextNested<A> withNewSecurityContext(){
            return new SecurityContextNestedImpl();
    }

    public V1EphemeralContainerFluent.SecurityContextNested<A> withNewSecurityContextLike(V1SecurityContext item){
            return new SecurityContextNestedImpl(item);
    }

    public V1EphemeralContainerFluent.SecurityContextNested<A> editSecurityContext(){
            return withNewSecurityContextLike(getSecurityContext());
    }

    public V1EphemeralContainerFluent.SecurityContextNested<A> editOrNewSecurityContext(){
            return withNewSecurityContextLike(getSecurityContext() != null ? getSecurityContext(): new V1SecurityContextBuilder().build());
    }

    public V1EphemeralContainerFluent.SecurityContextNested<A> editOrNewSecurityContextLike(V1SecurityContext item){
            return withNewSecurityContextLike(getSecurityContext() != null ? getSecurityContext(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStartupProbe instead.
 * @return The buildable object.
 */
@Deprecated public V1Probe getStartupProbe(){
            return this.startupProbe!=null?this.startupProbe.build():null;
    }

    public V1Probe buildStartupProbe(){
            return this.startupProbe!=null?this.startupProbe.build():null;
    }

    public A withStartupProbe(V1Probe startupProbe){
            _visitables.get("startupProbe").remove(this.startupProbe);
            if (startupProbe!=null){ this.startupProbe= new V1ProbeBuilder(startupProbe); _visitables.get("startupProbe").add(this.startupProbe);} return (A) this;
    }

    public Boolean hasStartupProbe(){
            return this.startupProbe != null;
    }

    public V1EphemeralContainerFluent.StartupProbeNested<A> withNewStartupProbe(){
            return new StartupProbeNestedImpl();
    }

    public V1EphemeralContainerFluent.StartupProbeNested<A> withNewStartupProbeLike(V1Probe item){
            return new StartupProbeNestedImpl(item);
    }

    public V1EphemeralContainerFluent.StartupProbeNested<A> editStartupProbe(){
            return withNewStartupProbeLike(getStartupProbe());
    }

    public V1EphemeralContainerFluent.StartupProbeNested<A> editOrNewStartupProbe(){
            return withNewStartupProbeLike(getStartupProbe() != null ? getStartupProbe(): new V1ProbeBuilder().build());
    }

    public V1EphemeralContainerFluent.StartupProbeNested<A> editOrNewStartupProbeLike(V1Probe item){
            return withNewStartupProbeLike(getStartupProbe() != null ? getStartupProbe(): item);
    }

    public Boolean isStdin(){
            return this.stdin;
    }

    public A withStdin(Boolean stdin){
            this.stdin=stdin; return (A) this;
    }

    public Boolean hasStdin(){
            return this.stdin != null;
    }

    public A withNewStdin(String arg1){
            return (A)withStdin(new Boolean(arg1));
    }

    public A withNewStdin(boolean arg1){
            return (A)withStdin(new Boolean(arg1));
    }

    public Boolean isStdinOnce(){
            return this.stdinOnce;
    }

    public A withStdinOnce(Boolean stdinOnce){
            this.stdinOnce=stdinOnce; return (A) this;
    }

    public Boolean hasStdinOnce(){
            return this.stdinOnce != null;
    }

    public A withNewStdinOnce(String arg1){
            return (A)withStdinOnce(new Boolean(arg1));
    }

    public A withNewStdinOnce(boolean arg1){
            return (A)withStdinOnce(new Boolean(arg1));
    }

    public String getTargetContainerName(){
            return this.targetContainerName;
    }

    public A withTargetContainerName(String targetContainerName){
            this.targetContainerName=targetContainerName; return (A) this;
    }

    public Boolean hasTargetContainerName(){
            return this.targetContainerName != null;
    }

    public A withNewTargetContainerName(String arg1){
            return (A)withTargetContainerName(new String(arg1));
    }

    public A withNewTargetContainerName(StringBuilder arg1){
            return (A)withTargetContainerName(new String(arg1));
    }

    public A withNewTargetContainerName(StringBuffer arg1){
            return (A)withTargetContainerName(new String(arg1));
    }

    public String getTerminationMessagePath(){
            return this.terminationMessagePath;
    }

    public A withTerminationMessagePath(String terminationMessagePath){
            this.terminationMessagePath=terminationMessagePath; return (A) this;
    }

    public Boolean hasTerminationMessagePath(){
            return this.terminationMessagePath != null;
    }

    public A withNewTerminationMessagePath(String arg1){
            return (A)withTerminationMessagePath(new String(arg1));
    }

    public A withNewTerminationMessagePath(StringBuilder arg1){
            return (A)withTerminationMessagePath(new String(arg1));
    }

    public A withNewTerminationMessagePath(StringBuffer arg1){
            return (A)withTerminationMessagePath(new String(arg1));
    }

    public String getTerminationMessagePolicy(){
            return this.terminationMessagePolicy;
    }

    public A withTerminationMessagePolicy(String terminationMessagePolicy){
            this.terminationMessagePolicy=terminationMessagePolicy; return (A) this;
    }

    public Boolean hasTerminationMessagePolicy(){
            return this.terminationMessagePolicy != null;
    }

    public A withNewTerminationMessagePolicy(String arg1){
            return (A)withTerminationMessagePolicy(new String(arg1));
    }

    public A withNewTerminationMessagePolicy(StringBuilder arg1){
            return (A)withTerminationMessagePolicy(new String(arg1));
    }

    public A withNewTerminationMessagePolicy(StringBuffer arg1){
            return (A)withTerminationMessagePolicy(new String(arg1));
    }

    public Boolean isTty(){
            return this.tty;
    }

    public A withTty(Boolean tty){
            this.tty=tty; return (A) this;
    }

    public Boolean hasTty(){
            return this.tty != null;
    }

    public A withNewTty(String arg1){
            return (A)withTty(new Boolean(arg1));
    }

    public A withNewTty(boolean arg1){
            return (A)withTty(new Boolean(arg1));
    }

    public A addToVolumeDevices(int index,V1VolumeDevice item){
            if (this.volumeDevices == null) {this.volumeDevices = new ArrayList<V1VolumeDeviceBuilder>();}
            V1VolumeDeviceBuilder builder = new V1VolumeDeviceBuilder(item);_visitables.get("volumeDevices").add(index >= 0 ? index : _visitables.get("volumeDevices").size(), builder);this.volumeDevices.add(index >= 0 ? index : volumeDevices.size(), builder); return (A)this;
    }

    public A setToVolumeDevices(int index,V1VolumeDevice item){
            if (this.volumeDevices == null) {this.volumeDevices = new ArrayList<V1VolumeDeviceBuilder>();}
            V1VolumeDeviceBuilder builder = new V1VolumeDeviceBuilder(item);
            if (index < 0 || index >= _visitables.get("volumeDevices").size()) { _visitables.get("volumeDevices").add(builder); } else { _visitables.get("volumeDevices").set(index, builder);}
            if (index < 0 || index >= volumeDevices.size()) { volumeDevices.add(builder); } else { volumeDevices.set(index, builder);}
             return (A)this;
    }

    public A addToVolumeDevices(V1VolumeDevice... items){
            if (this.volumeDevices == null) {this.volumeDevices = new ArrayList<V1VolumeDeviceBuilder>();}
            for (V1VolumeDevice item : items) {V1VolumeDeviceBuilder builder = new V1VolumeDeviceBuilder(item);_visitables.get("volumeDevices").add(builder);this.volumeDevices.add(builder);} return (A)this;
    }

    public A addAllToVolumeDevices(Collection<V1VolumeDevice> items){
            if (this.volumeDevices == null) {this.volumeDevices = new ArrayList<V1VolumeDeviceBuilder>();}
            for (V1VolumeDevice item : items) {V1VolumeDeviceBuilder builder = new V1VolumeDeviceBuilder(item);_visitables.get("volumeDevices").add(builder);this.volumeDevices.add(builder);} return (A)this;
    }

    public A removeFromVolumeDevices(V1VolumeDevice... items){
            for (V1VolumeDevice item : items) {V1VolumeDeviceBuilder builder = new V1VolumeDeviceBuilder(item);_visitables.get("volumeDevices").remove(builder);if (this.volumeDevices != null) {this.volumeDevices.remove(builder);}} return (A)this;
    }

    public A removeAllFromVolumeDevices(Collection<V1VolumeDevice> items){
            for (V1VolumeDevice item : items) {V1VolumeDeviceBuilder builder = new V1VolumeDeviceBuilder(item);_visitables.get("volumeDevices").remove(builder);if (this.volumeDevices != null) {this.volumeDevices.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromVolumeDevices(io.kubernetes.client.fluent.Predicate<V1VolumeDeviceBuilder> predicate){
            if (volumeDevices == null) return (A) this;
            final Iterator<V1VolumeDeviceBuilder> each = volumeDevices.iterator();
            final List visitables = _visitables.get("volumeDevices");
            while (each.hasNext()) {
              V1VolumeDeviceBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVolumeDevices instead.
 * @return The buildable object.
 */
@Deprecated public List<V1VolumeDevice> getVolumeDevices(){
            return build(volumeDevices);
    }

    public List<V1VolumeDevice> buildVolumeDevices(){
            return build(volumeDevices);
    }

    public V1VolumeDevice buildVolumeDevice(int index){
            return this.volumeDevices.get(index).build();
    }

    public V1VolumeDevice buildFirstVolumeDevice(){
            return this.volumeDevices.get(0).build();
    }

    public V1VolumeDevice buildLastVolumeDevice(){
            return this.volumeDevices.get(volumeDevices.size() - 1).build();
    }

    public V1VolumeDevice buildMatchingVolumeDevice(io.kubernetes.client.fluent.Predicate<V1VolumeDeviceBuilder> predicate){
            for (V1VolumeDeviceBuilder item: volumeDevices) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingVolumeDevice(io.kubernetes.client.fluent.Predicate<V1VolumeDeviceBuilder> predicate){
            for (V1VolumeDeviceBuilder item: volumeDevices) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withVolumeDevices(List<V1VolumeDevice> volumeDevices){
            if (this.volumeDevices != null) { _visitables.get("volumeDevices").removeAll(this.volumeDevices);}
            if (volumeDevices != null) {this.volumeDevices = new ArrayList<V1VolumeDeviceBuilder>(); for (V1VolumeDevice item : volumeDevices){this.addToVolumeDevices(item);}} else { this.volumeDevices = null;} return (A) this;
    }

    public A withVolumeDevices(V1VolumeDevice... volumeDevices){
            if (this.volumeDevices != null) {this.volumeDevices.clear();}
            if (volumeDevices != null) {for (V1VolumeDevice item :volumeDevices){ this.addToVolumeDevices(item);}} return (A) this;
    }

    public Boolean hasVolumeDevices(){
            return volumeDevices != null && !volumeDevices.isEmpty();
    }

    public V1EphemeralContainerFluent.VolumeDevicesNested<A> addNewVolumeDevice(){
            return new VolumeDevicesNestedImpl();
    }

    public V1EphemeralContainerFluent.VolumeDevicesNested<A> addNewVolumeDeviceLike(V1VolumeDevice item){
            return new VolumeDevicesNestedImpl(-1, item);
    }

    public V1EphemeralContainerFluent.VolumeDevicesNested<A> setNewVolumeDeviceLike(int index,V1VolumeDevice item){
            return new VolumeDevicesNestedImpl(index, item);
    }

    public V1EphemeralContainerFluent.VolumeDevicesNested<A> editVolumeDevice(int index){
            if (volumeDevices.size() <= index) throw new RuntimeException("Can't edit volumeDevices. Index exceeds size.");
            return setNewVolumeDeviceLike(index, buildVolumeDevice(index));
    }

    public V1EphemeralContainerFluent.VolumeDevicesNested<A> editFirstVolumeDevice(){
            if (volumeDevices.size() == 0) throw new RuntimeException("Can't edit first volumeDevices. The list is empty.");
            return setNewVolumeDeviceLike(0, buildVolumeDevice(0));
    }

    public V1EphemeralContainerFluent.VolumeDevicesNested<A> editLastVolumeDevice(){
            int index = volumeDevices.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last volumeDevices. The list is empty.");
            return setNewVolumeDeviceLike(index, buildVolumeDevice(index));
    }

    public V1EphemeralContainerFluent.VolumeDevicesNested<A> editMatchingVolumeDevice(io.kubernetes.client.fluent.Predicate<V1VolumeDeviceBuilder> predicate){
            int index = -1;
            for (int i=0;i<volumeDevices.size();i++) { 
            if (predicate.apply(volumeDevices.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching volumeDevices. No match found.");
            return setNewVolumeDeviceLike(index, buildVolumeDevice(index));
    }

    public A addToVolumeMounts(int index,V1VolumeMount item){
            if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<V1VolumeMountBuilder>();}
            V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);_visitables.get("volumeMounts").add(index >= 0 ? index : _visitables.get("volumeMounts").size(), builder);this.volumeMounts.add(index >= 0 ? index : volumeMounts.size(), builder); return (A)this;
    }

    public A setToVolumeMounts(int index,V1VolumeMount item){
            if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<V1VolumeMountBuilder>();}
            V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);
            if (index < 0 || index >= _visitables.get("volumeMounts").size()) { _visitables.get("volumeMounts").add(builder); } else { _visitables.get("volumeMounts").set(index, builder);}
            if (index < 0 || index >= volumeMounts.size()) { volumeMounts.add(builder); } else { volumeMounts.set(index, builder);}
             return (A)this;
    }

    public A addToVolumeMounts(V1VolumeMount... items){
            if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<V1VolumeMountBuilder>();}
            for (V1VolumeMount item : items) {V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
    }

    public A addAllToVolumeMounts(Collection<V1VolumeMount> items){
            if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<V1VolumeMountBuilder>();}
            for (V1VolumeMount item : items) {V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
    }

    public A removeFromVolumeMounts(V1VolumeMount... items){
            for (V1VolumeMount item : items) {V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);_visitables.get("volumeMounts").remove(builder);if (this.volumeMounts != null) {this.volumeMounts.remove(builder);}} return (A)this;
    }

    public A removeAllFromVolumeMounts(Collection<V1VolumeMount> items){
            for (V1VolumeMount item : items) {V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);_visitables.get("volumeMounts").remove(builder);if (this.volumeMounts != null) {this.volumeMounts.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromVolumeMounts(io.kubernetes.client.fluent.Predicate<V1VolumeMountBuilder> predicate){
            if (volumeMounts == null) return (A) this;
            final Iterator<V1VolumeMountBuilder> each = volumeMounts.iterator();
            final List visitables = _visitables.get("volumeMounts");
            while (each.hasNext()) {
              V1VolumeMountBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVolumeMounts instead.
 * @return The buildable object.
 */
@Deprecated public List<V1VolumeMount> getVolumeMounts(){
            return build(volumeMounts);
    }

    public List<V1VolumeMount> buildVolumeMounts(){
            return build(volumeMounts);
    }

    public V1VolumeMount buildVolumeMount(int index){
            return this.volumeMounts.get(index).build();
    }

    public V1VolumeMount buildFirstVolumeMount(){
            return this.volumeMounts.get(0).build();
    }

    public V1VolumeMount buildLastVolumeMount(){
            return this.volumeMounts.get(volumeMounts.size() - 1).build();
    }

    public V1VolumeMount buildMatchingVolumeMount(io.kubernetes.client.fluent.Predicate<V1VolumeMountBuilder> predicate){
            for (V1VolumeMountBuilder item: volumeMounts) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingVolumeMount(io.kubernetes.client.fluent.Predicate<V1VolumeMountBuilder> predicate){
            for (V1VolumeMountBuilder item: volumeMounts) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withVolumeMounts(List<V1VolumeMount> volumeMounts){
            if (this.volumeMounts != null) { _visitables.get("volumeMounts").removeAll(this.volumeMounts);}
            if (volumeMounts != null) {this.volumeMounts = new ArrayList<V1VolumeMountBuilder>(); for (V1VolumeMount item : volumeMounts){this.addToVolumeMounts(item);}} else { this.volumeMounts = null;} return (A) this;
    }

    public A withVolumeMounts(V1VolumeMount... volumeMounts){
            if (this.volumeMounts != null) {this.volumeMounts.clear();}
            if (volumeMounts != null) {for (V1VolumeMount item :volumeMounts){ this.addToVolumeMounts(item);}} return (A) this;
    }

    public Boolean hasVolumeMounts(){
            return volumeMounts != null && !volumeMounts.isEmpty();
    }

    public V1EphemeralContainerFluent.VolumeMountsNested<A> addNewVolumeMount(){
            return new VolumeMountsNestedImpl();
    }

    public V1EphemeralContainerFluent.VolumeMountsNested<A> addNewVolumeMountLike(V1VolumeMount item){
            return new VolumeMountsNestedImpl(-1, item);
    }

    public V1EphemeralContainerFluent.VolumeMountsNested<A> setNewVolumeMountLike(int index,V1VolumeMount item){
            return new VolumeMountsNestedImpl(index, item);
    }

    public V1EphemeralContainerFluent.VolumeMountsNested<A> editVolumeMount(int index){
            if (volumeMounts.size() <= index) throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
            return setNewVolumeMountLike(index, buildVolumeMount(index));
    }

    public V1EphemeralContainerFluent.VolumeMountsNested<A> editFirstVolumeMount(){
            if (volumeMounts.size() == 0) throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
            return setNewVolumeMountLike(0, buildVolumeMount(0));
    }

    public V1EphemeralContainerFluent.VolumeMountsNested<A> editLastVolumeMount(){
            int index = volumeMounts.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
            return setNewVolumeMountLike(index, buildVolumeMount(index));
    }

    public V1EphemeralContainerFluent.VolumeMountsNested<A> editMatchingVolumeMount(io.kubernetes.client.fluent.Predicate<V1VolumeMountBuilder> predicate){
            int index = -1;
            for (int i=0;i<volumeMounts.size();i++) { 
            if (predicate.apply(volumeMounts.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
            return setNewVolumeMountLike(index, buildVolumeMount(index));
    }

    public String getWorkingDir(){
            return this.workingDir;
    }

    public A withWorkingDir(String workingDir){
            this.workingDir=workingDir; return (A) this;
    }

    public Boolean hasWorkingDir(){
            return this.workingDir != null;
    }

    public A withNewWorkingDir(String arg1){
            return (A)withWorkingDir(new String(arg1));
    }

    public A withNewWorkingDir(StringBuilder arg1){
            return (A)withWorkingDir(new String(arg1));
    }

    public A withNewWorkingDir(StringBuffer arg1){
            return (A)withWorkingDir(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1EphemeralContainerFluentImpl that = (V1EphemeralContainerFluentImpl) o;
            if (args != null ? !args.equals(that.args) :that.args != null) return false;
            if (command != null ? !command.equals(that.command) :that.command != null) return false;
            if (env != null ? !env.equals(that.env) :that.env != null) return false;
            if (envFrom != null ? !envFrom.equals(that.envFrom) :that.envFrom != null) return false;
            if (image != null ? !image.equals(that.image) :that.image != null) return false;
            if (imagePullPolicy != null ? !imagePullPolicy.equals(that.imagePullPolicy) :that.imagePullPolicy != null) return false;
            if (lifecycle != null ? !lifecycle.equals(that.lifecycle) :that.lifecycle != null) return false;
            if (livenessProbe != null ? !livenessProbe.equals(that.livenessProbe) :that.livenessProbe != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
            if (readinessProbe != null ? !readinessProbe.equals(that.readinessProbe) :that.readinessProbe != null) return false;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            if (securityContext != null ? !securityContext.equals(that.securityContext) :that.securityContext != null) return false;
            if (startupProbe != null ? !startupProbe.equals(that.startupProbe) :that.startupProbe != null) return false;
            if (stdin != null ? !stdin.equals(that.stdin) :that.stdin != null) return false;
            if (stdinOnce != null ? !stdinOnce.equals(that.stdinOnce) :that.stdinOnce != null) return false;
            if (targetContainerName != null ? !targetContainerName.equals(that.targetContainerName) :that.targetContainerName != null) return false;
            if (terminationMessagePath != null ? !terminationMessagePath.equals(that.terminationMessagePath) :that.terminationMessagePath != null) return false;
            if (terminationMessagePolicy != null ? !terminationMessagePolicy.equals(that.terminationMessagePolicy) :that.terminationMessagePolicy != null) return false;
            if (tty != null ? !tty.equals(that.tty) :that.tty != null) return false;
            if (volumeDevices != null ? !volumeDevices.equals(that.volumeDevices) :that.volumeDevices != null) return false;
            if (volumeMounts != null ? !volumeMounts.equals(that.volumeMounts) :that.volumeMounts != null) return false;
            if (workingDir != null ? !workingDir.equals(that.workingDir) :that.workingDir != null) return false;
            return true;
    }


    public class EnvNestedImpl<N> extends V1EnvVarFluentImpl<V1EphemeralContainerFluent.EnvNested<N>> implements V1EphemeralContainerFluent.EnvNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1EnvVarBuilder builder;
        private final int index;
    
            EnvNestedImpl(int index,V1EnvVar item){
                    this.index = index;
                    this.builder = new V1EnvVarBuilder(this, item);
            }
            EnvNestedImpl(){
                    this.index = -1;
                    this.builder = new V1EnvVarBuilder(this);
            }
    
    public N and(){
            return (N) V1EphemeralContainerFluentImpl.this.setToEnv(index,builder.build());
    }
    public N endEnv(){
            return and();
    }

}
    public class EnvFromNestedImpl<N> extends V1EnvFromSourceFluentImpl<V1EphemeralContainerFluent.EnvFromNested<N>> implements V1EphemeralContainerFluent.EnvFromNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1EnvFromSourceBuilder builder;
        private final int index;
    
            EnvFromNestedImpl(int index,V1EnvFromSource item){
                    this.index = index;
                    this.builder = new V1EnvFromSourceBuilder(this, item);
            }
            EnvFromNestedImpl(){
                    this.index = -1;
                    this.builder = new V1EnvFromSourceBuilder(this);
            }
    
    public N and(){
            return (N) V1EphemeralContainerFluentImpl.this.setToEnvFrom(index,builder.build());
    }
    public N endEnvFrom(){
            return and();
    }

}
    public class LifecycleNestedImpl<N> extends V1LifecycleFluentImpl<V1EphemeralContainerFluent.LifecycleNested<N>> implements V1EphemeralContainerFluent.LifecycleNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LifecycleBuilder builder;
    
            LifecycleNestedImpl(V1Lifecycle item){
                    this.builder = new V1LifecycleBuilder(this, item);
            }
            LifecycleNestedImpl(){
                    this.builder = new V1LifecycleBuilder(this);
            }
    
    public N and(){
            return (N) V1EphemeralContainerFluentImpl.this.withLifecycle(builder.build());
    }
    public N endLifecycle(){
            return and();
    }

}
    public class LivenessProbeNestedImpl<N> extends V1ProbeFluentImpl<V1EphemeralContainerFluent.LivenessProbeNested<N>> implements V1EphemeralContainerFluent.LivenessProbeNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ProbeBuilder builder;
    
            LivenessProbeNestedImpl(V1Probe item){
                    this.builder = new V1ProbeBuilder(this, item);
            }
            LivenessProbeNestedImpl(){
                    this.builder = new V1ProbeBuilder(this);
            }
    
    public N and(){
            return (N) V1EphemeralContainerFluentImpl.this.withLivenessProbe(builder.build());
    }
    public N endLivenessProbe(){
            return and();
    }

}
    public class PortsNestedImpl<N> extends V1ContainerPortFluentImpl<V1EphemeralContainerFluent.PortsNested<N>> implements V1EphemeralContainerFluent.PortsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ContainerPortBuilder builder;
        private final int index;
    
            PortsNestedImpl(int index,V1ContainerPort item){
                    this.index = index;
                    this.builder = new V1ContainerPortBuilder(this, item);
            }
            PortsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1ContainerPortBuilder(this);
            }
    
    public N and(){
            return (N) V1EphemeralContainerFluentImpl.this.setToPorts(index,builder.build());
    }
    public N endPort(){
            return and();
    }

}
    public class ReadinessProbeNestedImpl<N> extends V1ProbeFluentImpl<V1EphemeralContainerFluent.ReadinessProbeNested<N>> implements V1EphemeralContainerFluent.ReadinessProbeNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ProbeBuilder builder;
    
            ReadinessProbeNestedImpl(V1Probe item){
                    this.builder = new V1ProbeBuilder(this, item);
            }
            ReadinessProbeNestedImpl(){
                    this.builder = new V1ProbeBuilder(this);
            }
    
    public N and(){
            return (N) V1EphemeralContainerFluentImpl.this.withReadinessProbe(builder.build());
    }
    public N endReadinessProbe(){
            return and();
    }

}
    public class ResourcesNestedImpl<N> extends V1ResourceRequirementsFluentImpl<V1EphemeralContainerFluent.ResourcesNested<N>> implements V1EphemeralContainerFluent.ResourcesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ResourceRequirementsBuilder builder;
    
            ResourcesNestedImpl(V1ResourceRequirements item){
                    this.builder = new V1ResourceRequirementsBuilder(this, item);
            }
            ResourcesNestedImpl(){
                    this.builder = new V1ResourceRequirementsBuilder(this);
            }
    
    public N and(){
            return (N) V1EphemeralContainerFluentImpl.this.withResources(builder.build());
    }
    public N endResources(){
            return and();
    }

}
    public class SecurityContextNestedImpl<N> extends V1SecurityContextFluentImpl<V1EphemeralContainerFluent.SecurityContextNested<N>> implements V1EphemeralContainerFluent.SecurityContextNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1SecurityContextBuilder builder;
    
            SecurityContextNestedImpl(V1SecurityContext item){
                    this.builder = new V1SecurityContextBuilder(this, item);
            }
            SecurityContextNestedImpl(){
                    this.builder = new V1SecurityContextBuilder(this);
            }
    
    public N and(){
            return (N) V1EphemeralContainerFluentImpl.this.withSecurityContext(builder.build());
    }
    public N endSecurityContext(){
            return and();
    }

}
    public class StartupProbeNestedImpl<N> extends V1ProbeFluentImpl<V1EphemeralContainerFluent.StartupProbeNested<N>> implements V1EphemeralContainerFluent.StartupProbeNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ProbeBuilder builder;
    
            StartupProbeNestedImpl(V1Probe item){
                    this.builder = new V1ProbeBuilder(this, item);
            }
            StartupProbeNestedImpl(){
                    this.builder = new V1ProbeBuilder(this);
            }
    
    public N and(){
            return (N) V1EphemeralContainerFluentImpl.this.withStartupProbe(builder.build());
    }
    public N endStartupProbe(){
            return and();
    }

}
    public class VolumeDevicesNestedImpl<N> extends V1VolumeDeviceFluentImpl<V1EphemeralContainerFluent.VolumeDevicesNested<N>> implements V1EphemeralContainerFluent.VolumeDevicesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1VolumeDeviceBuilder builder;
        private final int index;
    
            VolumeDevicesNestedImpl(int index,V1VolumeDevice item){
                    this.index = index;
                    this.builder = new V1VolumeDeviceBuilder(this, item);
            }
            VolumeDevicesNestedImpl(){
                    this.index = -1;
                    this.builder = new V1VolumeDeviceBuilder(this);
            }
    
    public N and(){
            return (N) V1EphemeralContainerFluentImpl.this.setToVolumeDevices(index,builder.build());
    }
    public N endVolumeDevice(){
            return and();
    }

}
    public class VolumeMountsNestedImpl<N> extends V1VolumeMountFluentImpl<V1EphemeralContainerFluent.VolumeMountsNested<N>> implements V1EphemeralContainerFluent.VolumeMountsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1VolumeMountBuilder builder;
        private final int index;
    
            VolumeMountsNestedImpl(int index,V1VolumeMount item){
                    this.index = index;
                    this.builder = new V1VolumeMountBuilder(this, item);
            }
            VolumeMountsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1VolumeMountBuilder(this);
            }
    
    public N and(){
            return (N) V1EphemeralContainerFluentImpl.this.setToVolumeMounts(index,builder.build());
    }
    public N endVolumeMount(){
            return and();
    }

}


}
