package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ContainerStateWaitingBuilder extends V1ContainerStateWaitingFluentImpl<V1ContainerStateWaitingBuilder> implements VisitableBuilder<V1ContainerStateWaiting,V1ContainerStateWaitingBuilder>{

    V1ContainerStateWaitingFluent<?> fluent;
    Boolean validationEnabled;

    public V1ContainerStateWaitingBuilder(){
            this(true);
    }
    public V1ContainerStateWaitingBuilder(Boolean validationEnabled){
            this(new V1ContainerStateWaiting(), validationEnabled);
    }
    public V1ContainerStateWaitingBuilder(V1ContainerStateWaitingFluent<?> fluent){
            this(fluent, true);
    }
    public V1ContainerStateWaitingBuilder(V1ContainerStateWaitingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1ContainerStateWaiting(), validationEnabled);
    }
    public V1ContainerStateWaitingBuilder(V1ContainerStateWaitingFluent<?> fluent,V1ContainerStateWaiting instance){
            this(fluent, instance, true);
    }
    public V1ContainerStateWaitingBuilder(V1ContainerStateWaitingFluent<?> fluent,V1ContainerStateWaiting instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMessage(instance.getMessage());

            fluent.withReason(instance.getReason());

            this.validationEnabled = validationEnabled; 
    }
    public V1ContainerStateWaitingBuilder(V1ContainerStateWaiting instance){
            this(instance,true);
    }
    public V1ContainerStateWaitingBuilder(V1ContainerStateWaiting instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMessage(instance.getMessage());

            this.withReason(instance.getReason());

            this.validationEnabled = validationEnabled; 
    }

    public V1ContainerStateWaiting build(){
            V1ContainerStateWaiting buildable = new V1ContainerStateWaiting();
            buildable.setMessage(fluent.getMessage());
            buildable.setReason(fluent.getReason());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ContainerStateWaitingBuilder that = (V1ContainerStateWaitingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
