package io.kubernetes.client.openapi.models;

import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import org.joda.time.DateTime;

public class V1ContainerStateTerminatedFluentImpl<A extends V1ContainerStateTerminatedFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1ContainerStateTerminatedFluent<A>{

    private String containerID;
    private Integer exitCode;
    private DateTime finishedAt;
    private String message;
    private String reason;
    private Integer signal;
    private DateTime startedAt;

    public V1ContainerStateTerminatedFluentImpl(){
    }
    public V1ContainerStateTerminatedFluentImpl(V1ContainerStateTerminated instance){
            this.withContainerID(instance.getContainerID());

            this.withExitCode(instance.getExitCode());

            this.withFinishedAt(instance.getFinishedAt());

            this.withMessage(instance.getMessage());

            this.withReason(instance.getReason());

            this.withSignal(instance.getSignal());

            this.withStartedAt(instance.getStartedAt());

    }

    public String getContainerID(){
            return this.containerID;
    }

    public A withContainerID(String containerID){
            this.containerID=containerID; return (A) this;
    }

    public Boolean hasContainerID(){
            return this.containerID != null;
    }

    public A withNewContainerID(String arg1){
            return (A)withContainerID(new String(arg1));
    }

    public A withNewContainerID(StringBuilder arg1){
            return (A)withContainerID(new String(arg1));
    }

    public A withNewContainerID(StringBuffer arg1){
            return (A)withContainerID(new String(arg1));
    }

    public Integer getExitCode(){
            return this.exitCode;
    }

    public A withExitCode(Integer exitCode){
            this.exitCode=exitCode; return (A) this;
    }

    public Boolean hasExitCode(){
            return this.exitCode != null;
    }

    public DateTime getFinishedAt(){
            return this.finishedAt;
    }

    public A withFinishedAt(DateTime finishedAt){
            this.finishedAt=finishedAt; return (A) this;
    }

    public Boolean hasFinishedAt(){
            return this.finishedAt != null;
    }

    public A withNewFinishedAt(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withFinishedAt(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewFinishedAt(Object arg0){
            return (A)withFinishedAt(new DateTime(arg0));
    }

    public A withNewFinishedAt(long arg0){
            return (A)withFinishedAt(new DateTime(arg0));
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public Boolean hasMessage(){
            return this.message != null;
    }

    public A withNewMessage(String arg1){
            return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuilder arg1){
            return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuffer arg1){
            return (A)withMessage(new String(arg1));
    }

    public String getReason(){
            return this.reason;
    }

    public A withReason(String reason){
            this.reason=reason; return (A) this;
    }

    public Boolean hasReason(){
            return this.reason != null;
    }

    public A withNewReason(String arg1){
            return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuilder arg1){
            return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuffer arg1){
            return (A)withReason(new String(arg1));
    }

    public Integer getSignal(){
            return this.signal;
    }

    public A withSignal(Integer signal){
            this.signal=signal; return (A) this;
    }

    public Boolean hasSignal(){
            return this.signal != null;
    }

    public DateTime getStartedAt(){
            return this.startedAt;
    }

    public A withStartedAt(DateTime startedAt){
            this.startedAt=startedAt; return (A) this;
    }

    public Boolean hasStartedAt(){
            return this.startedAt != null;
    }

    public A withNewStartedAt(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withStartedAt(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewStartedAt(Object arg0){
            return (A)withStartedAt(new DateTime(arg0));
    }

    public A withNewStartedAt(long arg0){
            return (A)withStartedAt(new DateTime(arg0));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1ContainerStateTerminatedFluentImpl that = (V1ContainerStateTerminatedFluentImpl) o;
            if (containerID != null ? !containerID.equals(that.containerID) :that.containerID != null) return false;
            if (exitCode != null ? !exitCode.equals(that.exitCode) :that.exitCode != null) return false;
            if (finishedAt != null ? !finishedAt.equals(that.finishedAt) :that.finishedAt != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
            if (signal != null ? !signal.equals(that.signal) :that.signal != null) return false;
            if (startedAt != null ? !startedAt.equals(that.startedAt) :that.startedAt != null) return false;
            return true;
    }




}
