package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ConfigMapKeySelectorBuilder extends V1ConfigMapKeySelectorFluentImpl<V1ConfigMapKeySelectorBuilder> implements VisitableBuilder<V1ConfigMapKeySelector,V1ConfigMapKeySelectorBuilder>{

    V1ConfigMapKeySelectorFluent<?> fluent;
    Boolean validationEnabled;

    public V1ConfigMapKeySelectorBuilder(){
            this(true);
    }
    public V1ConfigMapKeySelectorBuilder(Boolean validationEnabled){
            this(new V1ConfigMapKeySelector(), validationEnabled);
    }
    public V1ConfigMapKeySelectorBuilder(V1ConfigMapKeySelectorFluent<?> fluent){
            this(fluent, true);
    }
    public V1ConfigMapKeySelectorBuilder(V1ConfigMapKeySelectorFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1ConfigMapKeySelector(), validationEnabled);
    }
    public V1ConfigMapKeySelectorBuilder(V1ConfigMapKeySelectorFluent<?> fluent,V1ConfigMapKeySelector instance){
            this(fluent, instance, true);
    }
    public V1ConfigMapKeySelectorBuilder(V1ConfigMapKeySelectorFluent<?> fluent,V1ConfigMapKeySelector instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withKey(instance.getKey());

            fluent.withName(instance.getName());

            fluent.withOptional(instance.getOptional());

            this.validationEnabled = validationEnabled; 
    }
    public V1ConfigMapKeySelectorBuilder(V1ConfigMapKeySelector instance){
            this(instance,true);
    }
    public V1ConfigMapKeySelectorBuilder(V1ConfigMapKeySelector instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withKey(instance.getKey());

            this.withName(instance.getName());

            this.withOptional(instance.getOptional());

            this.validationEnabled = validationEnabled; 
    }

    public V1ConfigMapKeySelector build(){
            V1ConfigMapKeySelector buildable = new V1ConfigMapKeySelector();
            buildable.setKey(fluent.getKey());
            buildable.setName(fluent.getName());
            buildable.setOptional(fluent.isOptional());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ConfigMapKeySelectorBuilder that = (V1ConfigMapKeySelectorBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
