package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1ComponentStatusFluent<A extends V1ComponentStatusFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToConditions(int index,V1ComponentCondition item);
    public A setToConditions(int index,V1ComponentCondition item);
    public A addToConditions(V1ComponentCondition... items);
    public A addAllToConditions(Collection<V1ComponentCondition> items);
    public A removeFromConditions(V1ComponentCondition... items);
    public A removeAllFromConditions(Collection<V1ComponentCondition> items);
    public A removeMatchingFromConditions(io.kubernetes.client.fluent.Predicate<V1ComponentConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1ComponentCondition> getConditions();
    public List<V1ComponentCondition> buildConditions();
    public V1ComponentCondition buildCondition(int index);
    public V1ComponentCondition buildFirstCondition();
    public V1ComponentCondition buildLastCondition();
    public V1ComponentCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1ComponentConditionBuilder> predicate);
    public Boolean hasMatchingCondition(io.kubernetes.client.fluent.Predicate<V1ComponentConditionBuilder> predicate);
    public A withConditions(List<V1ComponentCondition> conditions);
    public A withConditions(V1ComponentCondition... conditions);
    public Boolean hasConditions();
    public V1ComponentStatusFluent.ConditionsNested<A> addNewCondition();
    public V1ComponentStatusFluent.ConditionsNested<A> addNewConditionLike(V1ComponentCondition item);
    public V1ComponentStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1ComponentCondition item);
    public V1ComponentStatusFluent.ConditionsNested<A> editCondition(int index);
    public V1ComponentStatusFluent.ConditionsNested<A> editFirstCondition();
    public V1ComponentStatusFluent.ConditionsNested<A> editLastCondition();
    public V1ComponentStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1ComponentConditionBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata();
    public V1ObjectMeta buildMetadata();
    public A withMetadata(V1ObjectMeta metadata);
    public Boolean hasMetadata();
    public V1ComponentStatusFluent.MetadataNested<A> withNewMetadata();
    public V1ComponentStatusFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item);
    public V1ComponentStatusFluent.MetadataNested<A> editMetadata();
    public V1ComponentStatusFluent.MetadataNested<A> editOrNewMetadata();
    public V1ComponentStatusFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item);

    public interface ConditionsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ComponentConditionFluent<V1ComponentStatusFluent.ConditionsNested<N>>{

        
    public N and();    public N endCondition();
}
    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectMetaFluent<V1ComponentStatusFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
