package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkingV1beta1IngressBackendBuilder extends NetworkingV1beta1IngressBackendFluentImpl<NetworkingV1beta1IngressBackendBuilder> implements VisitableBuilder<NetworkingV1beta1IngressBackend,NetworkingV1beta1IngressBackendBuilder>{

    NetworkingV1beta1IngressBackendFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkingV1beta1IngressBackendBuilder(){
            this(true);
    }
    public NetworkingV1beta1IngressBackendBuilder(Boolean validationEnabled){
            this(new NetworkingV1beta1IngressBackend(), validationEnabled);
    }
    public NetworkingV1beta1IngressBackendBuilder(NetworkingV1beta1IngressBackendFluent<?> fluent){
            this(fluent, true);
    }
    public NetworkingV1beta1IngressBackendBuilder(NetworkingV1beta1IngressBackendFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NetworkingV1beta1IngressBackend(), validationEnabled);
    }
    public NetworkingV1beta1IngressBackendBuilder(NetworkingV1beta1IngressBackendFluent<?> fluent,NetworkingV1beta1IngressBackend instance){
            this(fluent, instance, true);
    }
    public NetworkingV1beta1IngressBackendBuilder(NetworkingV1beta1IngressBackendFluent<?> fluent,NetworkingV1beta1IngressBackend instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withServiceName(instance.getServiceName());

            fluent.withServicePort(instance.getServicePort());

            this.validationEnabled = validationEnabled; 
    }
    public NetworkingV1beta1IngressBackendBuilder(NetworkingV1beta1IngressBackend instance){
            this(instance,true);
    }
    public NetworkingV1beta1IngressBackendBuilder(NetworkingV1beta1IngressBackend instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withServiceName(instance.getServiceName());

            this.withServicePort(instance.getServicePort());

            this.validationEnabled = validationEnabled; 
    }

    public NetworkingV1beta1IngressBackend build(){
            NetworkingV1beta1IngressBackend buildable = new NetworkingV1beta1IngressBackend();
            buildable.setServiceName(fluent.getServiceName());
            buildable.setServicePort(fluent.getServicePort());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetworkingV1beta1IngressBackendBuilder that = (NetworkingV1beta1IngressBackendBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
