package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;

public class AppsV1beta1DeploymentSpecFluentImpl<A extends AppsV1beta1DeploymentSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements AppsV1beta1DeploymentSpecFluent<A>{

    private Integer minReadySeconds;
    private Boolean paused;
    private Integer progressDeadlineSeconds;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private AppsV1beta1RollbackConfigBuilder rollbackTo;
    private V1LabelSelectorBuilder selector;
    private AppsV1beta1DeploymentStrategyBuilder strategy;
    private V1PodTemplateSpecBuilder template;

    public AppsV1beta1DeploymentSpecFluentImpl(){
    }
    public AppsV1beta1DeploymentSpecFluentImpl(AppsV1beta1DeploymentSpec instance){
            this.withMinReadySeconds(instance.getMinReadySeconds());

            this.withPaused(instance.getPaused());

            this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());

            this.withReplicas(instance.getReplicas());

            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());

            this.withRollbackTo(instance.getRollbackTo());

            this.withSelector(instance.getSelector());

            this.withStrategy(instance.getStrategy());

            this.withTemplate(instance.getTemplate());

    }

    public Integer getMinReadySeconds(){
            return this.minReadySeconds;
    }

    public A withMinReadySeconds(Integer minReadySeconds){
            this.minReadySeconds=minReadySeconds; return (A) this;
    }

    public Boolean hasMinReadySeconds(){
            return this.minReadySeconds != null;
    }

    public Boolean isPaused(){
            return this.paused;
    }

    public A withPaused(Boolean paused){
            this.paused=paused; return (A) this;
    }

    public Boolean hasPaused(){
            return this.paused != null;
    }

    public A withNewPaused(String arg1){
            return (A)withPaused(new Boolean(arg1));
    }

    public A withNewPaused(boolean arg1){
            return (A)withPaused(new Boolean(arg1));
    }

    public Integer getProgressDeadlineSeconds(){
            return this.progressDeadlineSeconds;
    }

    public A withProgressDeadlineSeconds(Integer progressDeadlineSeconds){
            this.progressDeadlineSeconds=progressDeadlineSeconds; return (A) this;
    }

    public Boolean hasProgressDeadlineSeconds(){
            return this.progressDeadlineSeconds != null;
    }

    public Integer getReplicas(){
            return this.replicas;
    }

    public A withReplicas(Integer replicas){
            this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas(){
            return this.replicas != null;
    }

    public Integer getRevisionHistoryLimit(){
            return this.revisionHistoryLimit;
    }

    public A withRevisionHistoryLimit(Integer revisionHistoryLimit){
            this.revisionHistoryLimit=revisionHistoryLimit; return (A) this;
    }

    public Boolean hasRevisionHistoryLimit(){
            return this.revisionHistoryLimit != null;
    }

    
/**
 * This method has been deprecated, please use method buildRollbackTo instead.
 * @return The buildable object.
 */
@Deprecated public AppsV1beta1RollbackConfig getRollbackTo(){
            return this.rollbackTo!=null?this.rollbackTo.build():null;
    }

    public AppsV1beta1RollbackConfig buildRollbackTo(){
            return this.rollbackTo!=null?this.rollbackTo.build():null;
    }

    public A withRollbackTo(AppsV1beta1RollbackConfig rollbackTo){
            _visitables.get("rollbackTo").remove(this.rollbackTo);
            if (rollbackTo!=null){ this.rollbackTo= new AppsV1beta1RollbackConfigBuilder(rollbackTo); _visitables.get("rollbackTo").add(this.rollbackTo);} return (A) this;
    }

    public Boolean hasRollbackTo(){
            return this.rollbackTo != null;
    }

    public AppsV1beta1DeploymentSpecFluent.RollbackToNested<A> withNewRollbackTo(){
            return new RollbackToNestedImpl();
    }

    public AppsV1beta1DeploymentSpecFluent.RollbackToNested<A> withNewRollbackToLike(AppsV1beta1RollbackConfig item){
            return new RollbackToNestedImpl(item);
    }

    public AppsV1beta1DeploymentSpecFluent.RollbackToNested<A> editRollbackTo(){
            return withNewRollbackToLike(getRollbackTo());
    }

    public AppsV1beta1DeploymentSpecFluent.RollbackToNested<A> editOrNewRollbackTo(){
            return withNewRollbackToLike(getRollbackTo() != null ? getRollbackTo(): new AppsV1beta1RollbackConfigBuilder().build());
    }

    public AppsV1beta1DeploymentSpecFluent.RollbackToNested<A> editOrNewRollbackToLike(AppsV1beta1RollbackConfig item){
            return withNewRollbackToLike(getRollbackTo() != null ? getRollbackTo(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public V1LabelSelector buildSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(V1LabelSelector selector){
            _visitables.get("selector").remove(this.selector);
            if (selector!=null){ this.selector= new V1LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector(){
            return this.selector != null;
    }

    public AppsV1beta1DeploymentSpecFluent.SelectorNested<A> withNewSelector(){
            return new SelectorNestedImpl();
    }

    public AppsV1beta1DeploymentSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item){
            return new SelectorNestedImpl(item);
    }

    public AppsV1beta1DeploymentSpecFluent.SelectorNested<A> editSelector(){
            return withNewSelectorLike(getSelector());
    }

    public AppsV1beta1DeploymentSpecFluent.SelectorNested<A> editOrNewSelector(){
            return withNewSelectorLike(getSelector() != null ? getSelector(): new V1LabelSelectorBuilder().build());
    }

    public AppsV1beta1DeploymentSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item){
            return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStrategy instead.
 * @return The buildable object.
 */
@Deprecated public AppsV1beta1DeploymentStrategy getStrategy(){
            return this.strategy!=null?this.strategy.build():null;
    }

    public AppsV1beta1DeploymentStrategy buildStrategy(){
            return this.strategy!=null?this.strategy.build():null;
    }

    public A withStrategy(AppsV1beta1DeploymentStrategy strategy){
            _visitables.get("strategy").remove(this.strategy);
            if (strategy!=null){ this.strategy= new AppsV1beta1DeploymentStrategyBuilder(strategy); _visitables.get("strategy").add(this.strategy);} return (A) this;
    }

    public Boolean hasStrategy(){
            return this.strategy != null;
    }

    public AppsV1beta1DeploymentSpecFluent.StrategyNested<A> withNewStrategy(){
            return new StrategyNestedImpl();
    }

    public AppsV1beta1DeploymentSpecFluent.StrategyNested<A> withNewStrategyLike(AppsV1beta1DeploymentStrategy item){
            return new StrategyNestedImpl(item);
    }

    public AppsV1beta1DeploymentSpecFluent.StrategyNested<A> editStrategy(){
            return withNewStrategyLike(getStrategy());
    }

    public AppsV1beta1DeploymentSpecFluent.StrategyNested<A> editOrNewStrategy(){
            return withNewStrategyLike(getStrategy() != null ? getStrategy(): new AppsV1beta1DeploymentStrategyBuilder().build());
    }

    public AppsV1beta1DeploymentSpecFluent.StrategyNested<A> editOrNewStrategyLike(AppsV1beta1DeploymentStrategy item){
            return withNewStrategyLike(getStrategy() != null ? getStrategy(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V1PodTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public V1PodTemplateSpec buildTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(V1PodTemplateSpec template){
            _visitables.get("template").remove(this.template);
            if (template!=null){ this.template= new V1PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template != null;
    }

    public AppsV1beta1DeploymentSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public AppsV1beta1DeploymentSpecFluent.TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public AppsV1beta1DeploymentSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public AppsV1beta1DeploymentSpecFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new V1PodTemplateSpecBuilder().build());
    }

    public AppsV1beta1DeploymentSpecFluent.TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            AppsV1beta1DeploymentSpecFluentImpl that = (AppsV1beta1DeploymentSpecFluentImpl) o;
            if (minReadySeconds != null ? !minReadySeconds.equals(that.minReadySeconds) :that.minReadySeconds != null) return false;
            if (paused != null ? !paused.equals(that.paused) :that.paused != null) return false;
            if (progressDeadlineSeconds != null ? !progressDeadlineSeconds.equals(that.progressDeadlineSeconds) :that.progressDeadlineSeconds != null) return false;
            if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
            if (revisionHistoryLimit != null ? !revisionHistoryLimit.equals(that.revisionHistoryLimit) :that.revisionHistoryLimit != null) return false;
            if (rollbackTo != null ? !rollbackTo.equals(that.rollbackTo) :that.rollbackTo != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            return true;
    }


    public class RollbackToNestedImpl<N> extends AppsV1beta1RollbackConfigFluentImpl<AppsV1beta1DeploymentSpecFluent.RollbackToNested<N>> implements AppsV1beta1DeploymentSpecFluent.RollbackToNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final AppsV1beta1RollbackConfigBuilder builder;
    
            RollbackToNestedImpl(AppsV1beta1RollbackConfig item){
                    this.builder = new AppsV1beta1RollbackConfigBuilder(this, item);
            }
            RollbackToNestedImpl(){
                    this.builder = new AppsV1beta1RollbackConfigBuilder(this);
            }
    
    public N and(){
            return (N) AppsV1beta1DeploymentSpecFluentImpl.this.withRollbackTo(builder.build());
    }
    public N endRollbackTo(){
            return and();
    }

}
    public class SelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<AppsV1beta1DeploymentSpecFluent.SelectorNested<N>> implements AppsV1beta1DeploymentSpecFluent.SelectorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorBuilder builder;
    
            SelectorNestedImpl(V1LabelSelector item){
                    this.builder = new V1LabelSelectorBuilder(this, item);
            }
            SelectorNestedImpl(){
                    this.builder = new V1LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) AppsV1beta1DeploymentSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector(){
            return and();
    }

}
    public class StrategyNestedImpl<N> extends AppsV1beta1DeploymentStrategyFluentImpl<AppsV1beta1DeploymentSpecFluent.StrategyNested<N>> implements AppsV1beta1DeploymentSpecFluent.StrategyNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final AppsV1beta1DeploymentStrategyBuilder builder;
    
            StrategyNestedImpl(AppsV1beta1DeploymentStrategy item){
                    this.builder = new AppsV1beta1DeploymentStrategyBuilder(this, item);
            }
            StrategyNestedImpl(){
                    this.builder = new AppsV1beta1DeploymentStrategyBuilder(this);
            }
    
    public N and(){
            return (N) AppsV1beta1DeploymentSpecFluentImpl.this.withStrategy(builder.build());
    }
    public N endStrategy(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends V1PodTemplateSpecFluentImpl<AppsV1beta1DeploymentSpecFluent.TemplateNested<N>> implements AppsV1beta1DeploymentSpecFluent.TemplateNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1PodTemplateSpecBuilder builder;
    
            TemplateNestedImpl(V1PodTemplateSpec item){
                    this.builder = new V1PodTemplateSpecBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new V1PodTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) AppsV1beta1DeploymentSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}


}
