package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AppsV1beta1DeploymentConditionBuilder extends AppsV1beta1DeploymentConditionFluentImpl<AppsV1beta1DeploymentConditionBuilder> implements VisitableBuilder<AppsV1beta1DeploymentCondition,AppsV1beta1DeploymentConditionBuilder>{

    AppsV1beta1DeploymentConditionFluent<?> fluent;
    Boolean validationEnabled;

    public AppsV1beta1DeploymentConditionBuilder(){
            this(true);
    }
    public AppsV1beta1DeploymentConditionBuilder(Boolean validationEnabled){
            this(new AppsV1beta1DeploymentCondition(), validationEnabled);
    }
    public AppsV1beta1DeploymentConditionBuilder(AppsV1beta1DeploymentConditionFluent<?> fluent){
            this(fluent, true);
    }
    public AppsV1beta1DeploymentConditionBuilder(AppsV1beta1DeploymentConditionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AppsV1beta1DeploymentCondition(), validationEnabled);
    }
    public AppsV1beta1DeploymentConditionBuilder(AppsV1beta1DeploymentConditionFluent<?> fluent,AppsV1beta1DeploymentCondition instance){
            this(fluent, instance, true);
    }
    public AppsV1beta1DeploymentConditionBuilder(AppsV1beta1DeploymentConditionFluent<?> fluent,AppsV1beta1DeploymentCondition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLastTransitionTime(instance.getLastTransitionTime());

            fluent.withLastUpdateTime(instance.getLastUpdateTime());

            fluent.withMessage(instance.getMessage());

            fluent.withReason(instance.getReason());

            fluent.withStatus(instance.getStatus());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public AppsV1beta1DeploymentConditionBuilder(AppsV1beta1DeploymentCondition instance){
            this(instance,true);
    }
    public AppsV1beta1DeploymentConditionBuilder(AppsV1beta1DeploymentCondition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLastTransitionTime(instance.getLastTransitionTime());

            this.withLastUpdateTime(instance.getLastUpdateTime());

            this.withMessage(instance.getMessage());

            this.withReason(instance.getReason());

            this.withStatus(instance.getStatus());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public AppsV1beta1DeploymentCondition build(){
            AppsV1beta1DeploymentCondition buildable = new AppsV1beta1DeploymentCondition();
            buildable.setLastTransitionTime(fluent.getLastTransitionTime());
            buildable.setLastUpdateTime(fluent.getLastUpdateTime());
            buildable.setMessage(fluent.getMessage());
            buildable.setReason(fluent.getReason());
            buildable.setStatus(fluent.getStatus());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AppsV1beta1DeploymentConditionBuilder that = (AppsV1beta1DeploymentConditionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
