package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AdmissionregistrationV1WebhookClientConfigBuilder extends AdmissionregistrationV1WebhookClientConfigFluentImpl<AdmissionregistrationV1WebhookClientConfigBuilder> implements VisitableBuilder<AdmissionregistrationV1WebhookClientConfig,AdmissionregistrationV1WebhookClientConfigBuilder>{

    AdmissionregistrationV1WebhookClientConfigFluent<?> fluent;
    Boolean validationEnabled;

    public AdmissionregistrationV1WebhookClientConfigBuilder(){
            this(true);
    }
    public AdmissionregistrationV1WebhookClientConfigBuilder(Boolean validationEnabled){
            this(new AdmissionregistrationV1WebhookClientConfig(), validationEnabled);
    }
    public AdmissionregistrationV1WebhookClientConfigBuilder(AdmissionregistrationV1WebhookClientConfigFluent<?> fluent){
            this(fluent, true);
    }
    public AdmissionregistrationV1WebhookClientConfigBuilder(AdmissionregistrationV1WebhookClientConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AdmissionregistrationV1WebhookClientConfig(), validationEnabled);
    }
    public AdmissionregistrationV1WebhookClientConfigBuilder(AdmissionregistrationV1WebhookClientConfigFluent<?> fluent,AdmissionregistrationV1WebhookClientConfig instance){
            this(fluent, instance, true);
    }
    public AdmissionregistrationV1WebhookClientConfigBuilder(AdmissionregistrationV1WebhookClientConfigFluent<?> fluent,AdmissionregistrationV1WebhookClientConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCaBundle(instance.getCaBundle());

            fluent.withService(instance.getService());

            fluent.withUrl(instance.getUrl());

            this.validationEnabled = validationEnabled; 
    }
    public AdmissionregistrationV1WebhookClientConfigBuilder(AdmissionregistrationV1WebhookClientConfig instance){
            this(instance,true);
    }
    public AdmissionregistrationV1WebhookClientConfigBuilder(AdmissionregistrationV1WebhookClientConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCaBundle(instance.getCaBundle());

            this.withService(instance.getService());

            this.withUrl(instance.getUrl());

            this.validationEnabled = validationEnabled; 
    }

    public AdmissionregistrationV1WebhookClientConfig build(){
            AdmissionregistrationV1WebhookClientConfig buildable = new AdmissionregistrationV1WebhookClientConfig();
            buildable.setCaBundle(fluent.getCaBundle());
            buildable.setService(fluent.getService());
            buildable.setUrl(fluent.getUrl());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AdmissionregistrationV1WebhookClientConfigBuilder that = (AdmissionregistrationV1WebhookClientConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
