/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.NetworkingV1beta1IngressBackend;
import io.kubernetes.client.models.NetworkingV1beta1IngressRule;
import io.kubernetes.client.models.NetworkingV1beta1IngressTLS;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="IngressSpec describes the Ingress the user wishes to exist.")
public class NetworkingV1beta1IngressSpec {
    @SerializedName(value="backend")
    private NetworkingV1beta1IngressBackend backend = null;
    @SerializedName(value="rules")
    private List<NetworkingV1beta1IngressRule> rules = null;
    @SerializedName(value="tls")
    private List<NetworkingV1beta1IngressTLS> tls = null;

    public NetworkingV1beta1IngressSpec backend(NetworkingV1beta1IngressBackend backend) {
        this.backend = backend;
        return this;
    }

    @ApiModelProperty(value="A default backend capable of servicing requests that don't match any rule. At least one of 'backend' or 'rules' must be specified. This field is optional to allow the loadbalancer controller or defaulting logic to specify a global default.")
    public NetworkingV1beta1IngressBackend getBackend() {
        return this.backend;
    }

    public void setBackend(NetworkingV1beta1IngressBackend backend) {
        this.backend = backend;
    }

    public NetworkingV1beta1IngressSpec rules(List<NetworkingV1beta1IngressRule> rules) {
        this.rules = rules;
        return this;
    }

    public NetworkingV1beta1IngressSpec addRulesItem(NetworkingV1beta1IngressRule rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<NetworkingV1beta1IngressRule>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    @ApiModelProperty(value="A list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.")
    public List<NetworkingV1beta1IngressRule> getRules() {
        return this.rules;
    }

    public void setRules(List<NetworkingV1beta1IngressRule> rules) {
        this.rules = rules;
    }

    public NetworkingV1beta1IngressSpec tls(List<NetworkingV1beta1IngressTLS> tls) {
        this.tls = tls;
        return this;
    }

    public NetworkingV1beta1IngressSpec addTlsItem(NetworkingV1beta1IngressTLS tlsItem) {
        if (this.tls == null) {
            this.tls = new ArrayList<NetworkingV1beta1IngressTLS>();
        }
        this.tls.add(tlsItem);
        return this;
    }

    @ApiModelProperty(value="TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.")
    public List<NetworkingV1beta1IngressTLS> getTls() {
        return this.tls;
    }

    public void setTls(List<NetworkingV1beta1IngressTLS> tls) {
        this.tls = tls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkingV1beta1IngressSpec networkingV1beta1IngressSpec = (NetworkingV1beta1IngressSpec)o;
        return Objects.equals(this.backend, networkingV1beta1IngressSpec.backend) && Objects.equals(this.rules, networkingV1beta1IngressSpec.rules) && Objects.equals(this.tls, networkingV1beta1IngressSpec.tls);
    }

    public int hashCode() {
        return Objects.hash(this.backend, this.rules, this.tls);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NetworkingV1beta1IngressSpec {\n");
        sb.append("    backend: ").append(this.toIndentedString(this.backend)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("    tls: ").append(this.toIndentedString(this.tls)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

