/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.apis;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.kubernetes.client.ApiCallback;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.ApiResponse;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.Pair;
import io.kubernetes.client.ProgressRequestBody;
import io.kubernetes.client.ProgressResponseBody;
import io.kubernetes.client.models.V1APIResourceList;
import io.kubernetes.client.models.V1beta1LocalSubjectAccessReview;
import io.kubernetes.client.models.V1beta1SelfSubjectAccessReview;
import io.kubernetes.client.models.V1beta1SelfSubjectRulesReview;
import io.kubernetes.client.models.V1beta1SubjectAccessReview;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class AuthorizationV1beta1Api {
    private ApiClient apiClient;

    public AuthorizationV1beta1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationV1beta1Api(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createNamespacedLocalSubjectAccessReviewCall(String namespace, V1beta1LocalSubjectAccessReview body, String dryRun, String fieldManager, String pretty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        V1beta1LocalSubjectAccessReview localVarPostBody = body;
        String localVarPath = "/apis/authorization.k8s.io/v1beta1/namespaces/{namespace}/localsubjectaccessreviews".replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createNamespacedLocalSubjectAccessReviewValidateBeforeCall(String namespace, V1beta1LocalSubjectAccessReview body, String dryRun, String fieldManager, String pretty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createNamespacedLocalSubjectAccessReview(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createNamespacedLocalSubjectAccessReview(Async)");
        }
        Call call = this.createNamespacedLocalSubjectAccessReviewCall(namespace, body, dryRun, fieldManager, pretty, progressListener, progressRequestListener);
        return call;
    }

    public V1beta1LocalSubjectAccessReview createNamespacedLocalSubjectAccessReview(String namespace, V1beta1LocalSubjectAccessReview body, String dryRun, String fieldManager, String pretty) throws ApiException {
        ApiResponse<V1beta1LocalSubjectAccessReview> resp = this.createNamespacedLocalSubjectAccessReviewWithHttpInfo(namespace, body, dryRun, fieldManager, pretty);
        return resp.getData();
    }

    public ApiResponse<V1beta1LocalSubjectAccessReview> createNamespacedLocalSubjectAccessReviewWithHttpInfo(String namespace, V1beta1LocalSubjectAccessReview body, String dryRun, String fieldManager, String pretty) throws ApiException {
        Call call = this.createNamespacedLocalSubjectAccessReviewValidateBeforeCall(namespace, body, dryRun, fieldManager, pretty, null, null);
        Type localVarReturnType = new TypeToken<V1beta1LocalSubjectAccessReview>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createNamespacedLocalSubjectAccessReviewAsync(String namespace, V1beta1LocalSubjectAccessReview body, String dryRun, String fieldManager, String pretty, final ApiCallback<V1beta1LocalSubjectAccessReview> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createNamespacedLocalSubjectAccessReviewValidateBeforeCall(namespace, body, dryRun, fieldManager, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V1beta1LocalSubjectAccessReview>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createSelfSubjectAccessReviewCall(V1beta1SelfSubjectAccessReview body, String dryRun, String fieldManager, String pretty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        V1beta1SelfSubjectAccessReview localVarPostBody = body;
        String localVarPath = "/apis/authorization.k8s.io/v1beta1/selfsubjectaccessreviews";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createSelfSubjectAccessReviewValidateBeforeCall(V1beta1SelfSubjectAccessReview body, String dryRun, String fieldManager, String pretty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createSelfSubjectAccessReview(Async)");
        }
        Call call = this.createSelfSubjectAccessReviewCall(body, dryRun, fieldManager, pretty, progressListener, progressRequestListener);
        return call;
    }

    public V1beta1SelfSubjectAccessReview createSelfSubjectAccessReview(V1beta1SelfSubjectAccessReview body, String dryRun, String fieldManager, String pretty) throws ApiException {
        ApiResponse<V1beta1SelfSubjectAccessReview> resp = this.createSelfSubjectAccessReviewWithHttpInfo(body, dryRun, fieldManager, pretty);
        return resp.getData();
    }

    public ApiResponse<V1beta1SelfSubjectAccessReview> createSelfSubjectAccessReviewWithHttpInfo(V1beta1SelfSubjectAccessReview body, String dryRun, String fieldManager, String pretty) throws ApiException {
        Call call = this.createSelfSubjectAccessReviewValidateBeforeCall(body, dryRun, fieldManager, pretty, null, null);
        Type localVarReturnType = new TypeToken<V1beta1SelfSubjectAccessReview>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createSelfSubjectAccessReviewAsync(V1beta1SelfSubjectAccessReview body, String dryRun, String fieldManager, String pretty, final ApiCallback<V1beta1SelfSubjectAccessReview> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSelfSubjectAccessReviewValidateBeforeCall(body, dryRun, fieldManager, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V1beta1SelfSubjectAccessReview>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createSelfSubjectRulesReviewCall(V1beta1SelfSubjectRulesReview body, String dryRun, String fieldManager, String pretty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        V1beta1SelfSubjectRulesReview localVarPostBody = body;
        String localVarPath = "/apis/authorization.k8s.io/v1beta1/selfsubjectrulesreviews";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createSelfSubjectRulesReviewValidateBeforeCall(V1beta1SelfSubjectRulesReview body, String dryRun, String fieldManager, String pretty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createSelfSubjectRulesReview(Async)");
        }
        Call call = this.createSelfSubjectRulesReviewCall(body, dryRun, fieldManager, pretty, progressListener, progressRequestListener);
        return call;
    }

    public V1beta1SelfSubjectRulesReview createSelfSubjectRulesReview(V1beta1SelfSubjectRulesReview body, String dryRun, String fieldManager, String pretty) throws ApiException {
        ApiResponse<V1beta1SelfSubjectRulesReview> resp = this.createSelfSubjectRulesReviewWithHttpInfo(body, dryRun, fieldManager, pretty);
        return resp.getData();
    }

    public ApiResponse<V1beta1SelfSubjectRulesReview> createSelfSubjectRulesReviewWithHttpInfo(V1beta1SelfSubjectRulesReview body, String dryRun, String fieldManager, String pretty) throws ApiException {
        Call call = this.createSelfSubjectRulesReviewValidateBeforeCall(body, dryRun, fieldManager, pretty, null, null);
        Type localVarReturnType = new TypeToken<V1beta1SelfSubjectRulesReview>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createSelfSubjectRulesReviewAsync(V1beta1SelfSubjectRulesReview body, String dryRun, String fieldManager, String pretty, final ApiCallback<V1beta1SelfSubjectRulesReview> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSelfSubjectRulesReviewValidateBeforeCall(body, dryRun, fieldManager, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V1beta1SelfSubjectRulesReview>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createSubjectAccessReviewCall(V1beta1SubjectAccessReview body, String dryRun, String fieldManager, String pretty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        V1beta1SubjectAccessReview localVarPostBody = body;
        String localVarPath = "/apis/authorization.k8s.io/v1beta1/subjectaccessreviews";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createSubjectAccessReviewValidateBeforeCall(V1beta1SubjectAccessReview body, String dryRun, String fieldManager, String pretty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createSubjectAccessReview(Async)");
        }
        Call call = this.createSubjectAccessReviewCall(body, dryRun, fieldManager, pretty, progressListener, progressRequestListener);
        return call;
    }

    public V1beta1SubjectAccessReview createSubjectAccessReview(V1beta1SubjectAccessReview body, String dryRun, String fieldManager, String pretty) throws ApiException {
        ApiResponse<V1beta1SubjectAccessReview> resp = this.createSubjectAccessReviewWithHttpInfo(body, dryRun, fieldManager, pretty);
        return resp.getData();
    }

    public ApiResponse<V1beta1SubjectAccessReview> createSubjectAccessReviewWithHttpInfo(V1beta1SubjectAccessReview body, String dryRun, String fieldManager, String pretty) throws ApiException {
        Call call = this.createSubjectAccessReviewValidateBeforeCall(body, dryRun, fieldManager, pretty, null, null);
        Type localVarReturnType = new TypeToken<V1beta1SubjectAccessReview>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createSubjectAccessReviewAsync(V1beta1SubjectAccessReview body, String dryRun, String fieldManager, String pretty, final ApiCallback<V1beta1SubjectAccessReview> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSubjectAccessReviewValidateBeforeCall(body, dryRun, fieldManager, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V1beta1SubjectAccessReview>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAPIResourcesCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/authorization.k8s.io/v1beta1/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAPIResourcesValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAPIResourcesCall(progressListener, progressRequestListener);
        return call;
    }

    public V1APIResourceList getAPIResources() throws ApiException {
        ApiResponse<V1APIResourceList> resp = this.getAPIResourcesWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<V1APIResourceList> getAPIResourcesWithHttpInfo() throws ApiException {
        Call call = this.getAPIResourcesValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAPIResourcesAsync(final ApiCallback<V1APIResourceList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAPIResourcesValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

