/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1LabelSelector;
import io.kubernetes.client.models.V1beta1RuleWithOperations;
import io.kubernetes.client.models.V1beta1WebhookClientConfig;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Webhook describes an admission webhook and the resources and operations it applies to.")
public class V1beta1Webhook {
    @SerializedName(value="clientConfig")
    private V1beta1WebhookClientConfig clientConfig = null;
    @SerializedName(value="failurePolicy")
    private String failurePolicy = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="namespaceSelector")
    private V1LabelSelector namespaceSelector = null;
    @SerializedName(value="rules")
    private List<V1beta1RuleWithOperations> rules = null;
    @SerializedName(value="sideEffects")
    private String sideEffects = null;

    public V1beta1Webhook clientConfig(V1beta1WebhookClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        return this;
    }

    @ApiModelProperty(required=true, value="ClientConfig defines how to communicate with the hook. Required")
    public V1beta1WebhookClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(V1beta1WebhookClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public V1beta1Webhook failurePolicy(String failurePolicy) {
        this.failurePolicy = failurePolicy;
        return this;
    }

    @ApiModelProperty(value="FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Ignore.")
    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    public void setFailurePolicy(String failurePolicy) {
        this.failurePolicy = failurePolicy;
    }

    public V1beta1Webhook name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where \"imagepolicy\" is the name of the webhook, and kubernetes.io is the name of the organization. Required.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1beta1Webhook namespaceSelector(V1LabelSelector namespaceSelector) {
        this.namespaceSelector = namespaceSelector;
        return this;
    }

    @ApiModelProperty(value="NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.  For example, to run the webhook on any objects whose namespace is not associated with \"runlevel\" of \"0\" or \"1\";  you will set the selector as follows: \"namespaceSelector\": {   \"matchExpressions\": [     {       \"key\": \"runlevel\",       \"operator\": \"NotIn\",       \"values\": [         \"0\",         \"1\"       ]     }   ] }  If instead you want to only run the webhook on any objects whose namespace is associated with the \"environment\" of \"prod\" or \"staging\"; you will set the selector as follows: \"namespaceSelector\": {   \"matchExpressions\": [     {       \"key\": \"environment\",       \"operator\": \"In\",       \"values\": [         \"prod\",         \"staging\"       ]     }   ] }  See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.  Default to the empty LabelSelector, which matches everything.")
    public V1LabelSelector getNamespaceSelector() {
        return this.namespaceSelector;
    }

    public void setNamespaceSelector(V1LabelSelector namespaceSelector) {
        this.namespaceSelector = namespaceSelector;
    }

    public V1beta1Webhook rules(List<V1beta1RuleWithOperations> rules) {
        this.rules = rules;
        return this;
    }

    public V1beta1Webhook addRulesItem(V1beta1RuleWithOperations rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1beta1RuleWithOperations>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    @ApiModelProperty(value="Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.")
    public List<V1beta1RuleWithOperations> getRules() {
        return this.rules;
    }

    public void setRules(List<V1beta1RuleWithOperations> rules) {
        this.rules = rules;
    }

    public V1beta1Webhook sideEffects(String sideEffects) {
        this.sideEffects = sideEffects;
        return this;
    }

    @ApiModelProperty(value="SideEffects states whether this webhookk has side effects. Acceptable values are: Unknown, None, Some, NoneOnDryRun Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission change and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some. Defaults to Unknown.")
    public String getSideEffects() {
        return this.sideEffects;
    }

    public void setSideEffects(String sideEffects) {
        this.sideEffects = sideEffects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1Webhook v1beta1Webhook = (V1beta1Webhook)o;
        return Objects.equals(this.clientConfig, v1beta1Webhook.clientConfig) && Objects.equals(this.failurePolicy, v1beta1Webhook.failurePolicy) && Objects.equals(this.name, v1beta1Webhook.name) && Objects.equals(this.namespaceSelector, v1beta1Webhook.namespaceSelector) && Objects.equals(this.rules, v1beta1Webhook.rules) && Objects.equals(this.sideEffects, v1beta1Webhook.sideEffects);
    }

    public int hashCode() {
        return Objects.hash(this.clientConfig, this.failurePolicy, this.name, this.namespaceSelector, this.rules, this.sideEffects);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1Webhook {\n");
        sb.append("    clientConfig: ").append(this.toIndentedString(this.clientConfig)).append("\n");
        sb.append("    failurePolicy: ").append(this.toIndentedString(this.failurePolicy)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespaceSelector: ").append(this.toIndentedString(this.namespaceSelector)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("    sideEffects: ").append(this.toIndentedString(this.sideEffects)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

