package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V2beta1ObjectMetricStatusFluentImpl<A extends V2beta1ObjectMetricStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V2beta1ObjectMetricStatusFluent<A>{

    private String currentValue;
    private String metricName;
    private V2beta1CrossVersionObjectReferenceBuilder target;

    public V2beta1ObjectMetricStatusFluentImpl(){
    }
    public V2beta1ObjectMetricStatusFluentImpl(V2beta1ObjectMetricStatus instance){
            this.withCurrentValue(instance.getCurrentValue());

            this.withMetricName(instance.getMetricName());

            this.withTarget(instance.getTarget());

    }

    public String getCurrentValue(){
            return this.currentValue;
    }

    public A withCurrentValue(String currentValue){
            this.currentValue=currentValue; return (A) this;
    }

    public Boolean hasCurrentValue(){
            return this.currentValue != null;
    }

    public String getMetricName(){
            return this.metricName;
    }

    public A withMetricName(String metricName){
            this.metricName=metricName; return (A) this;
    }

    public Boolean hasMetricName(){
            return this.metricName != null;
    }

    
/**
 * This method has been deprecated, please use method buildTarget instead.
 * @return The buildable object.
 */
@Deprecated public V2beta1CrossVersionObjectReference getTarget(){
            return this.target!=null?this.target.build():null;
    }

    public V2beta1CrossVersionObjectReference buildTarget(){
            return this.target!=null?this.target.build():null;
    }

    public A withTarget(V2beta1CrossVersionObjectReference target){
            _visitables.remove(this.target);
            if (target!=null){ this.target= new V2beta1CrossVersionObjectReferenceBuilder(target); _visitables.add(this.target);} return (A) this;
    }

    public Boolean hasTarget(){
            return this.target != null;
    }

    public V2beta1ObjectMetricStatusFluent.TargetNested<A> withNewTarget(){
            return new TargetNestedImpl();
    }

    public V2beta1ObjectMetricStatusFluent.TargetNested<A> withNewTargetLike(V2beta1CrossVersionObjectReference item){
            return new TargetNestedImpl(item);
    }

    public V2beta1ObjectMetricStatusFluent.TargetNested<A> editTarget(){
            return withNewTargetLike(getTarget());
    }

    public V2beta1ObjectMetricStatusFluent.TargetNested<A> editOrNewTarget(){
            return withNewTargetLike(getTarget() != null ? getTarget(): new V2beta1CrossVersionObjectReferenceBuilder().build());
    }

    public V2beta1ObjectMetricStatusFluent.TargetNested<A> editOrNewTargetLike(V2beta1CrossVersionObjectReference item){
            return withNewTargetLike(getTarget() != null ? getTarget(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2beta1ObjectMetricStatusFluentImpl that = (V2beta1ObjectMetricStatusFluentImpl) o;
            if (currentValue != null ? !currentValue.equals(that.currentValue) :that.currentValue != null) return false;
            if (metricName != null ? !metricName.equals(that.metricName) :that.metricName != null) return false;
            if (target != null ? !target.equals(that.target) :that.target != null) return false;
            return true;
    }


    public class TargetNestedImpl<N> extends V2beta1CrossVersionObjectReferenceFluentImpl<V2beta1ObjectMetricStatusFluent.TargetNested<N>> implements V2beta1ObjectMetricStatusFluent.TargetNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V2beta1CrossVersionObjectReferenceBuilder builder;
    
            TargetNestedImpl(V2beta1CrossVersionObjectReference item){
                    this.builder = new V2beta1CrossVersionObjectReferenceBuilder(this, item);
            }
            TargetNestedImpl(){
                    this.builder = new V2beta1CrossVersionObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) V2beta1ObjectMetricStatusFluentImpl.this.withTarget(builder.build());
    }
    public N endTarget(){
            return and();
    }

}


}
