package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V2beta1HorizontalPodAutoscalerConditionBuilder extends V2beta1HorizontalPodAutoscalerConditionFluentImpl<V2beta1HorizontalPodAutoscalerConditionBuilder> implements VisitableBuilder<V2beta1HorizontalPodAutoscalerCondition,V2beta1HorizontalPodAutoscalerConditionBuilder>{

    V2beta1HorizontalPodAutoscalerConditionFluent<?> fluent;
    Boolean validationEnabled;

    public V2beta1HorizontalPodAutoscalerConditionBuilder(){
            this(true);
    }
    public V2beta1HorizontalPodAutoscalerConditionBuilder(Boolean validationEnabled){
            this(new V2beta1HorizontalPodAutoscalerCondition(), validationEnabled);
    }
    public V2beta1HorizontalPodAutoscalerConditionBuilder(V2beta1HorizontalPodAutoscalerConditionFluent<?> fluent){
            this(fluent, true);
    }
    public V2beta1HorizontalPodAutoscalerConditionBuilder(V2beta1HorizontalPodAutoscalerConditionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V2beta1HorizontalPodAutoscalerCondition(), validationEnabled);
    }
    public V2beta1HorizontalPodAutoscalerConditionBuilder(V2beta1HorizontalPodAutoscalerConditionFluent<?> fluent,V2beta1HorizontalPodAutoscalerCondition instance){
            this(fluent, instance, true);
    }
    public V2beta1HorizontalPodAutoscalerConditionBuilder(V2beta1HorizontalPodAutoscalerConditionFluent<?> fluent,V2beta1HorizontalPodAutoscalerCondition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLastTransitionTime(instance.getLastTransitionTime());

            fluent.withMessage(instance.getMessage());

            fluent.withReason(instance.getReason());

            fluent.withStatus(instance.getStatus());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V2beta1HorizontalPodAutoscalerConditionBuilder(V2beta1HorizontalPodAutoscalerCondition instance){
            this(instance,true);
    }
    public V2beta1HorizontalPodAutoscalerConditionBuilder(V2beta1HorizontalPodAutoscalerCondition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLastTransitionTime(instance.getLastTransitionTime());

            this.withMessage(instance.getMessage());

            this.withReason(instance.getReason());

            this.withStatus(instance.getStatus());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V2beta1HorizontalPodAutoscalerCondition build(){
            V2beta1HorizontalPodAutoscalerCondition buildable = new V2beta1HorizontalPodAutoscalerCondition();
            buildable.setLastTransitionTime(fluent.getLastTransitionTime());
            buildable.setMessage(fluent.getMessage());
            buildable.setReason(fluent.getReason());
            buildable.setStatus(fluent.getStatus());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2beta1HorizontalPodAutoscalerConditionBuilder that = (V2beta1HorizontalPodAutoscalerConditionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
