package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V2alpha1CronJobBuilder extends V2alpha1CronJobFluentImpl<V2alpha1CronJobBuilder> implements VisitableBuilder<V2alpha1CronJob,V2alpha1CronJobBuilder>{

    V2alpha1CronJobFluent<?> fluent;
    Boolean validationEnabled;

    public V2alpha1CronJobBuilder(){
            this(true);
    }
    public V2alpha1CronJobBuilder(Boolean validationEnabled){
            this(new V2alpha1CronJob(), validationEnabled);
    }
    public V2alpha1CronJobBuilder(V2alpha1CronJobFluent<?> fluent){
            this(fluent, true);
    }
    public V2alpha1CronJobBuilder(V2alpha1CronJobFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V2alpha1CronJob(), validationEnabled);
    }
    public V2alpha1CronJobBuilder(V2alpha1CronJobFluent<?> fluent,V2alpha1CronJob instance){
            this(fluent, instance, true);
    }
    public V2alpha1CronJobBuilder(V2alpha1CronJobFluent<?> fluent,V2alpha1CronJob instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V2alpha1CronJobBuilder(V2alpha1CronJob instance){
            this(instance,true);
    }
    public V2alpha1CronJobBuilder(V2alpha1CronJob instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V2alpha1CronJob build(){
            V2alpha1CronJob buildable = new V2alpha1CronJob();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2alpha1CronJobBuilder that = (V2alpha1CronJobBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
