package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2RollingUpdateDeploymentBuilder extends V1beta2RollingUpdateDeploymentFluentImpl<V1beta2RollingUpdateDeploymentBuilder> implements VisitableBuilder<V1beta2RollingUpdateDeployment,V1beta2RollingUpdateDeploymentBuilder>{

    V1beta2RollingUpdateDeploymentFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta2RollingUpdateDeploymentBuilder(){
            this(true);
    }
    public V1beta2RollingUpdateDeploymentBuilder(Boolean validationEnabled){
            this(new V1beta2RollingUpdateDeployment(), validationEnabled);
    }
    public V1beta2RollingUpdateDeploymentBuilder(V1beta2RollingUpdateDeploymentFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta2RollingUpdateDeploymentBuilder(V1beta2RollingUpdateDeploymentFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta2RollingUpdateDeployment(), validationEnabled);
    }
    public V1beta2RollingUpdateDeploymentBuilder(V1beta2RollingUpdateDeploymentFluent<?> fluent,V1beta2RollingUpdateDeployment instance){
            this(fluent, instance, true);
    }
    public V1beta2RollingUpdateDeploymentBuilder(V1beta2RollingUpdateDeploymentFluent<?> fluent,V1beta2RollingUpdateDeployment instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMaxSurge(instance.getMaxSurge());

            fluent.withMaxUnavailable(instance.getMaxUnavailable());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta2RollingUpdateDeploymentBuilder(V1beta2RollingUpdateDeployment instance){
            this(instance,true);
    }
    public V1beta2RollingUpdateDeploymentBuilder(V1beta2RollingUpdateDeployment instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMaxSurge(instance.getMaxSurge());

            this.withMaxUnavailable(instance.getMaxUnavailable());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta2RollingUpdateDeployment build(){
            V1beta2RollingUpdateDeployment buildable = new V1beta2RollingUpdateDeployment();
            buildable.setMaxSurge(fluent.getMaxSurge());
            buildable.setMaxUnavailable(fluent.getMaxUnavailable());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2RollingUpdateDeploymentBuilder that = (V1beta2RollingUpdateDeploymentBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
