package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2DaemonSetSpecBuilder extends V1beta2DaemonSetSpecFluentImpl<V1beta2DaemonSetSpecBuilder> implements VisitableBuilder<V1beta2DaemonSetSpec,V1beta2DaemonSetSpecBuilder>{

    V1beta2DaemonSetSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta2DaemonSetSpecBuilder(){
            this(true);
    }
    public V1beta2DaemonSetSpecBuilder(Boolean validationEnabled){
            this(new V1beta2DaemonSetSpec(), validationEnabled);
    }
    public V1beta2DaemonSetSpecBuilder(V1beta2DaemonSetSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta2DaemonSetSpecBuilder(V1beta2DaemonSetSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta2DaemonSetSpec(), validationEnabled);
    }
    public V1beta2DaemonSetSpecBuilder(V1beta2DaemonSetSpecFluent<?> fluent,V1beta2DaemonSetSpec instance){
            this(fluent, instance, true);
    }
    public V1beta2DaemonSetSpecBuilder(V1beta2DaemonSetSpecFluent<?> fluent,V1beta2DaemonSetSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMinReadySeconds(instance.getMinReadySeconds());

            fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());

            fluent.withSelector(instance.getSelector());

            fluent.withTemplate(instance.getTemplate());

            fluent.withUpdateStrategy(instance.getUpdateStrategy());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta2DaemonSetSpecBuilder(V1beta2DaemonSetSpec instance){
            this(instance,true);
    }
    public V1beta2DaemonSetSpecBuilder(V1beta2DaemonSetSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMinReadySeconds(instance.getMinReadySeconds());

            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());

            this.withSelector(instance.getSelector());

            this.withTemplate(instance.getTemplate());

            this.withUpdateStrategy(instance.getUpdateStrategy());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta2DaemonSetSpec build(){
            V1beta2DaemonSetSpec buildable = new V1beta2DaemonSetSpec();
            buildable.setMinReadySeconds(fluent.getMinReadySeconds());
            buildable.setRevisionHistoryLimit(fluent.getRevisionHistoryLimit());
            buildable.setSelector(fluent.getSelector());
            buildable.setTemplate(fluent.getTemplate());
            buildable.setUpdateStrategy(fluent.getUpdateStrategy());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2DaemonSetSpecBuilder that = (V1beta2DaemonSetSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
