package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1beta1StatefulSetStatusFluent<A extends V1beta1StatefulSetStatusFluent<A>> extends Fluent<A>{


    public Integer getCollisionCount();
    public A withCollisionCount(Integer collisionCount);
    public Boolean hasCollisionCount();
    public A withNewCollisionCount(int arg1);
    public A withNewCollisionCount(String arg1);
    public A addToConditions(int index,V1beta1StatefulSetCondition item);
    public A setToConditions(int index,V1beta1StatefulSetCondition item);
    public A addToConditions(V1beta1StatefulSetCondition... items);
    public A addAllToConditions(Collection<V1beta1StatefulSetCondition> items);
    public A removeFromConditions(V1beta1StatefulSetCondition... items);
    public A removeAllFromConditions(Collection<V1beta1StatefulSetCondition> items);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1StatefulSetCondition> getConditions();
    public List<V1beta1StatefulSetCondition> buildConditions();
    public V1beta1StatefulSetCondition buildCondition(int index);
    public V1beta1StatefulSetCondition buildFirstCondition();
    public V1beta1StatefulSetCondition buildLastCondition();
    public V1beta1StatefulSetCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta1StatefulSetConditionBuilder> predicate);
    public A withConditions(List<V1beta1StatefulSetCondition> conditions);
    public A withConditions(V1beta1StatefulSetCondition... conditions);
    public Boolean hasConditions();
    public V1beta1StatefulSetStatusFluent.ConditionsNested<A> addNewCondition();
    public V1beta1StatefulSetStatusFluent.ConditionsNested<A> addNewConditionLike(V1beta1StatefulSetCondition item);
    public V1beta1StatefulSetStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1beta1StatefulSetCondition item);
    public V1beta1StatefulSetStatusFluent.ConditionsNested<A> editCondition(int index);
    public V1beta1StatefulSetStatusFluent.ConditionsNested<A> editFirstCondition();
    public V1beta1StatefulSetStatusFluent.ConditionsNested<A> editLastCondition();
    public V1beta1StatefulSetStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta1StatefulSetConditionBuilder> predicate);
    public Integer getCurrentReplicas();
    public A withCurrentReplicas(Integer currentReplicas);
    public Boolean hasCurrentReplicas();
    public A withNewCurrentReplicas(int arg1);
    public A withNewCurrentReplicas(String arg1);
    public String getCurrentRevision();
    public A withCurrentRevision(String currentRevision);
    public Boolean hasCurrentRevision();
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public A withNewObservedGeneration(String arg1);
    public A withNewObservedGeneration(long arg1);
    public Integer getReadyReplicas();
    public A withReadyReplicas(Integer readyReplicas);
    public Boolean hasReadyReplicas();
    public A withNewReadyReplicas(int arg1);
    public A withNewReadyReplicas(String arg1);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public A withNewReplicas(int arg1);
    public A withNewReplicas(String arg1);
    public String getUpdateRevision();
    public A withUpdateRevision(String updateRevision);
    public Boolean hasUpdateRevision();
    public Integer getUpdatedReplicas();
    public A withUpdatedReplicas(Integer updatedReplicas);
    public Boolean hasUpdatedReplicas();
    public A withNewUpdatedReplicas(int arg1);
    public A withNewUpdatedReplicas(String arg1);

    public interface ConditionsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1beta1StatefulSetConditionFluent<V1beta1StatefulSetStatusFluent.ConditionsNested<N>>{

        
    public N and();    public N endCondition();
}


}
