package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1SelfSubjectAccessReviewBuilder extends V1beta1SelfSubjectAccessReviewFluentImpl<V1beta1SelfSubjectAccessReviewBuilder> implements VisitableBuilder<V1beta1SelfSubjectAccessReview,V1beta1SelfSubjectAccessReviewBuilder>{

    V1beta1SelfSubjectAccessReviewFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1SelfSubjectAccessReviewBuilder(){
            this(true);
    }
    public V1beta1SelfSubjectAccessReviewBuilder(Boolean validationEnabled){
            this(new V1beta1SelfSubjectAccessReview(), validationEnabled);
    }
    public V1beta1SelfSubjectAccessReviewBuilder(V1beta1SelfSubjectAccessReviewFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1SelfSubjectAccessReviewBuilder(V1beta1SelfSubjectAccessReviewFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1SelfSubjectAccessReview(), validationEnabled);
    }
    public V1beta1SelfSubjectAccessReviewBuilder(V1beta1SelfSubjectAccessReviewFluent<?> fluent,V1beta1SelfSubjectAccessReview instance){
            this(fluent, instance, true);
    }
    public V1beta1SelfSubjectAccessReviewBuilder(V1beta1SelfSubjectAccessReviewFluent<?> fluent,V1beta1SelfSubjectAccessReview instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1SelfSubjectAccessReviewBuilder(V1beta1SelfSubjectAccessReview instance){
            this(instance,true);
    }
    public V1beta1SelfSubjectAccessReviewBuilder(V1beta1SelfSubjectAccessReview instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1SelfSubjectAccessReview build(){
            V1beta1SelfSubjectAccessReview buildable = new V1beta1SelfSubjectAccessReview();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1SelfSubjectAccessReviewBuilder that = (V1beta1SelfSubjectAccessReviewBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
