package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1beta1ReplicaSetStatusFluent<A extends V1beta1ReplicaSetStatusFluent<A>> extends Fluent<A>{


    public Integer getAvailableReplicas();
    public A withAvailableReplicas(Integer availableReplicas);
    public Boolean hasAvailableReplicas();
    public A withNewAvailableReplicas(int arg1);
    public A withNewAvailableReplicas(String arg1);
    public A addToConditions(int index,V1beta1ReplicaSetCondition item);
    public A setToConditions(int index,V1beta1ReplicaSetCondition item);
    public A addToConditions(V1beta1ReplicaSetCondition... items);
    public A addAllToConditions(Collection<V1beta1ReplicaSetCondition> items);
    public A removeFromConditions(V1beta1ReplicaSetCondition... items);
    public A removeAllFromConditions(Collection<V1beta1ReplicaSetCondition> items);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1ReplicaSetCondition> getConditions();
    public List<V1beta1ReplicaSetCondition> buildConditions();
    public V1beta1ReplicaSetCondition buildCondition(int index);
    public V1beta1ReplicaSetCondition buildFirstCondition();
    public V1beta1ReplicaSetCondition buildLastCondition();
    public V1beta1ReplicaSetCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta1ReplicaSetConditionBuilder> predicate);
    public A withConditions(List<V1beta1ReplicaSetCondition> conditions);
    public A withConditions(V1beta1ReplicaSetCondition... conditions);
    public Boolean hasConditions();
    public V1beta1ReplicaSetStatusFluent.ConditionsNested<A> addNewCondition();
    public V1beta1ReplicaSetStatusFluent.ConditionsNested<A> addNewConditionLike(V1beta1ReplicaSetCondition item);
    public V1beta1ReplicaSetStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1beta1ReplicaSetCondition item);
    public V1beta1ReplicaSetStatusFluent.ConditionsNested<A> editCondition(int index);
    public V1beta1ReplicaSetStatusFluent.ConditionsNested<A> editFirstCondition();
    public V1beta1ReplicaSetStatusFluent.ConditionsNested<A> editLastCondition();
    public V1beta1ReplicaSetStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta1ReplicaSetConditionBuilder> predicate);
    public Integer getFullyLabeledReplicas();
    public A withFullyLabeledReplicas(Integer fullyLabeledReplicas);
    public Boolean hasFullyLabeledReplicas();
    public A withNewFullyLabeledReplicas(int arg1);
    public A withNewFullyLabeledReplicas(String arg1);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public A withNewObservedGeneration(String arg1);
    public A withNewObservedGeneration(long arg1);
    public Integer getReadyReplicas();
    public A withReadyReplicas(Integer readyReplicas);
    public Boolean hasReadyReplicas();
    public A withNewReadyReplicas(int arg1);
    public A withNewReadyReplicas(String arg1);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public A withNewReplicas(int arg1);
    public A withNewReplicas(String arg1);

    public interface ConditionsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1beta1ReplicaSetConditionFluent<V1beta1ReplicaSetStatusFluent.ConditionsNested<N>>{

        
    public N and();    public N endCondition();
}


}
