package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1NetworkPolicySpecBuilder extends V1beta1NetworkPolicySpecFluentImpl<V1beta1NetworkPolicySpecBuilder> implements VisitableBuilder<V1beta1NetworkPolicySpec,V1beta1NetworkPolicySpecBuilder>{

    V1beta1NetworkPolicySpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1NetworkPolicySpecBuilder(){
            this(true);
    }
    public V1beta1NetworkPolicySpecBuilder(Boolean validationEnabled){
            this(new V1beta1NetworkPolicySpec(), validationEnabled);
    }
    public V1beta1NetworkPolicySpecBuilder(V1beta1NetworkPolicySpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1NetworkPolicySpecBuilder(V1beta1NetworkPolicySpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1NetworkPolicySpec(), validationEnabled);
    }
    public V1beta1NetworkPolicySpecBuilder(V1beta1NetworkPolicySpecFluent<?> fluent,V1beta1NetworkPolicySpec instance){
            this(fluent, instance, true);
    }
    public V1beta1NetworkPolicySpecBuilder(V1beta1NetworkPolicySpecFluent<?> fluent,V1beta1NetworkPolicySpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEgress(instance.getEgress());

            fluent.withIngress(instance.getIngress());

            fluent.withPodSelector(instance.getPodSelector());

            fluent.withPolicyTypes(instance.getPolicyTypes());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1NetworkPolicySpecBuilder(V1beta1NetworkPolicySpec instance){
            this(instance,true);
    }
    public V1beta1NetworkPolicySpecBuilder(V1beta1NetworkPolicySpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEgress(instance.getEgress());

            this.withIngress(instance.getIngress());

            this.withPodSelector(instance.getPodSelector());

            this.withPolicyTypes(instance.getPolicyTypes());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1NetworkPolicySpec build(){
            V1beta1NetworkPolicySpec buildable = new V1beta1NetworkPolicySpec();
            buildable.setEgress(fluent.getEgress());
            buildable.setIngress(fluent.getIngress());
            buildable.setPodSelector(fluent.getPodSelector());
            buildable.setPolicyTypes(fluent.getPolicyTypes());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1NetworkPolicySpecBuilder that = (V1beta1NetworkPolicySpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
