package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1NetworkPolicyBuilder extends V1beta1NetworkPolicyFluentImpl<V1beta1NetworkPolicyBuilder> implements VisitableBuilder<V1beta1NetworkPolicy,V1beta1NetworkPolicyBuilder>{

    V1beta1NetworkPolicyFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1NetworkPolicyBuilder(){
            this(true);
    }
    public V1beta1NetworkPolicyBuilder(Boolean validationEnabled){
            this(new V1beta1NetworkPolicy(), validationEnabled);
    }
    public V1beta1NetworkPolicyBuilder(V1beta1NetworkPolicyFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1NetworkPolicyBuilder(V1beta1NetworkPolicyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1NetworkPolicy(), validationEnabled);
    }
    public V1beta1NetworkPolicyBuilder(V1beta1NetworkPolicyFluent<?> fluent,V1beta1NetworkPolicy instance){
            this(fluent, instance, true);
    }
    public V1beta1NetworkPolicyBuilder(V1beta1NetworkPolicyFluent<?> fluent,V1beta1NetworkPolicy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1NetworkPolicyBuilder(V1beta1NetworkPolicy instance){
            this(instance,true);
    }
    public V1beta1NetworkPolicyBuilder(V1beta1NetworkPolicy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1NetworkPolicy build(){
            V1beta1NetworkPolicy buildable = new V1beta1NetworkPolicy();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1NetworkPolicyBuilder that = (V1beta1NetworkPolicyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
