package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1IngressStatusBuilder extends V1beta1IngressStatusFluentImpl<V1beta1IngressStatusBuilder> implements VisitableBuilder<V1beta1IngressStatus,V1beta1IngressStatusBuilder>{

    V1beta1IngressStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1IngressStatusBuilder(){
            this(true);
    }
    public V1beta1IngressStatusBuilder(Boolean validationEnabled){
            this(new V1beta1IngressStatus(), validationEnabled);
    }
    public V1beta1IngressStatusBuilder(V1beta1IngressStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1IngressStatusBuilder(V1beta1IngressStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1IngressStatus(), validationEnabled);
    }
    public V1beta1IngressStatusBuilder(V1beta1IngressStatusFluent<?> fluent,V1beta1IngressStatus instance){
            this(fluent, instance, true);
    }
    public V1beta1IngressStatusBuilder(V1beta1IngressStatusFluent<?> fluent,V1beta1IngressStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLoadBalancer(instance.getLoadBalancer());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1IngressStatusBuilder(V1beta1IngressStatus instance){
            this(instance,true);
    }
    public V1beta1IngressStatusBuilder(V1beta1IngressStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLoadBalancer(instance.getLoadBalancer());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1IngressStatus build(){
            V1beta1IngressStatus buildable = new V1beta1IngressStatus();
            buildable.setLoadBalancer(fluent.getLoadBalancer());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1IngressStatusBuilder that = (V1beta1IngressStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
