package io.kubernetes.client.models;

import io.kubernetes.client.custom.IntOrString;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1beta1IngressBackendFluentImpl<A extends V1beta1IngressBackendFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1IngressBackendFluent<A>{

    private String serviceName;
    private IntOrString servicePort;

    public V1beta1IngressBackendFluentImpl(){
    }
    public V1beta1IngressBackendFluentImpl(V1beta1IngressBackend instance){
            this.withServiceName(instance.getServiceName());

            this.withServicePort(instance.getServicePort());

    }

    public String getServiceName(){
            return this.serviceName;
    }

    public A withServiceName(String serviceName){
            this.serviceName=serviceName; return (A) this;
    }

    public Boolean hasServiceName(){
            return this.serviceName != null;
    }

    public IntOrString getServicePort(){
            return this.servicePort;
    }

    public A withServicePort(IntOrString servicePort){
            this.servicePort=servicePort; return (A) this;
    }

    public Boolean hasServicePort(){
            return this.servicePort != null;
    }

    public A withNewServicePort(final String value){
            return (A)withServicePort(new IntOrString(value));
    }

    public A withNewServicePort(final int value){
            return (A)withServicePort(new IntOrString(value));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1IngressBackendFluentImpl that = (V1beta1IngressBackendFluentImpl) o;
            if (serviceName != null ? !serviceName.equals(that.serviceName) :that.serviceName != null) return false;
            if (servicePort != null ? !servicePort.equals(that.servicePort) :that.servicePort != null) return false;
            return true;
    }




}
