package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1beta1AggregationRuleFluentImpl<A extends V1beta1AggregationRuleFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1AggregationRuleFluent<A>{

    private List<V1LabelSelectorBuilder> clusterRoleSelectors;

    public V1beta1AggregationRuleFluentImpl(){
    }
    public V1beta1AggregationRuleFluentImpl(V1beta1AggregationRule instance){
            this.withClusterRoleSelectors(instance.getClusterRoleSelectors());

    }

    public A addToClusterRoleSelectors(int index,V1LabelSelector item){
            if (this.clusterRoleSelectors == null) {this.clusterRoleSelectors = new ArrayList<V1LabelSelectorBuilder>();}
            V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.clusterRoleSelectors.add(index >= 0 ? index : clusterRoleSelectors.size(), builder); return (A)this;
    }

    public A setToClusterRoleSelectors(int index,V1LabelSelector item){
            if (this.clusterRoleSelectors == null) {this.clusterRoleSelectors = new ArrayList<V1LabelSelectorBuilder>();}
            V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= clusterRoleSelectors.size()) { clusterRoleSelectors.add(builder); } else { clusterRoleSelectors.set(index, builder);}
             return (A)this;
    }

    public A addToClusterRoleSelectors(V1LabelSelector... items){
            if (this.clusterRoleSelectors == null) {this.clusterRoleSelectors = new ArrayList<V1LabelSelectorBuilder>();}
            for (V1LabelSelector item : items) {V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);_visitables.add(builder);this.clusterRoleSelectors.add(builder);} return (A)this;
    }

    public A addAllToClusterRoleSelectors(Collection<V1LabelSelector> items){
            if (this.clusterRoleSelectors == null) {this.clusterRoleSelectors = new ArrayList<V1LabelSelectorBuilder>();}
            for (V1LabelSelector item : items) {V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);_visitables.add(builder);this.clusterRoleSelectors.add(builder);} return (A)this;
    }

    public A removeFromClusterRoleSelectors(V1LabelSelector... items){
            for (V1LabelSelector item : items) {V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);_visitables.remove(builder);if (this.clusterRoleSelectors != null) {this.clusterRoleSelectors.remove(builder);}} return (A)this;
    }

    public A removeAllFromClusterRoleSelectors(Collection<V1LabelSelector> items){
            for (V1LabelSelector item : items) {V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);_visitables.remove(builder);if (this.clusterRoleSelectors != null) {this.clusterRoleSelectors.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildClusterRoleSelectors instead.
 * @return The buildable object.
 */
@Deprecated public List<V1LabelSelector> getClusterRoleSelectors(){
            return build(clusterRoleSelectors);
    }

    public List<V1LabelSelector> buildClusterRoleSelectors(){
            return build(clusterRoleSelectors);
    }

    public V1LabelSelector buildClusterRoleSelector(int index){
            return this.clusterRoleSelectors.get(index).build();
    }

    public V1LabelSelector buildFirstClusterRoleSelector(){
            return this.clusterRoleSelectors.get(0).build();
    }

    public V1LabelSelector buildLastClusterRoleSelector(){
            return this.clusterRoleSelectors.get(clusterRoleSelectors.size() - 1).build();
    }

    public V1LabelSelector buildMatchingClusterRoleSelector(io.kubernetes.client.fluent.Predicate<V1LabelSelectorBuilder> predicate){
            for (V1LabelSelectorBuilder item: clusterRoleSelectors) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withClusterRoleSelectors(List<V1LabelSelector> clusterRoleSelectors){
            if (this.clusterRoleSelectors != null) { _visitables.removeAll(this.clusterRoleSelectors);}
            if (clusterRoleSelectors != null) {this.clusterRoleSelectors = new ArrayList<V1LabelSelectorBuilder>(); for (V1LabelSelector item : clusterRoleSelectors){this.addToClusterRoleSelectors(item);}} else { this.clusterRoleSelectors = null;} return (A) this;
    }

    public A withClusterRoleSelectors(V1LabelSelector... clusterRoleSelectors){
            if (this.clusterRoleSelectors != null) {this.clusterRoleSelectors.clear();}
            if (clusterRoleSelectors != null) {for (V1LabelSelector item :clusterRoleSelectors){ this.addToClusterRoleSelectors(item);}} return (A) this;
    }

    public Boolean hasClusterRoleSelectors(){
            return clusterRoleSelectors != null && !clusterRoleSelectors.isEmpty();
    }

    public V1beta1AggregationRuleFluent.ClusterRoleSelectorsNested<A> addNewClusterRoleSelector(){
            return new ClusterRoleSelectorsNestedImpl();
    }

    public V1beta1AggregationRuleFluent.ClusterRoleSelectorsNested<A> addNewClusterRoleSelectorLike(V1LabelSelector item){
            return new ClusterRoleSelectorsNestedImpl(-1, item);
    }

    public V1beta1AggregationRuleFluent.ClusterRoleSelectorsNested<A> setNewClusterRoleSelectorLike(int index,V1LabelSelector item){
            return new ClusterRoleSelectorsNestedImpl(index, item);
    }

    public V1beta1AggregationRuleFluent.ClusterRoleSelectorsNested<A> editClusterRoleSelector(int index){
            if (clusterRoleSelectors.size() <= index) throw new RuntimeException("Can't edit clusterRoleSelectors. Index exceeds size.");
            return setNewClusterRoleSelectorLike(index, buildClusterRoleSelector(index));
    }

    public V1beta1AggregationRuleFluent.ClusterRoleSelectorsNested<A> editFirstClusterRoleSelector(){
            if (clusterRoleSelectors.size() == 0) throw new RuntimeException("Can't edit first clusterRoleSelectors. The list is empty.");
            return setNewClusterRoleSelectorLike(0, buildClusterRoleSelector(0));
    }

    public V1beta1AggregationRuleFluent.ClusterRoleSelectorsNested<A> editLastClusterRoleSelector(){
            int index = clusterRoleSelectors.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last clusterRoleSelectors. The list is empty.");
            return setNewClusterRoleSelectorLike(index, buildClusterRoleSelector(index));
    }

    public V1beta1AggregationRuleFluent.ClusterRoleSelectorsNested<A> editMatchingClusterRoleSelector(io.kubernetes.client.fluent.Predicate<V1LabelSelectorBuilder> predicate){
            int index = -1;
            for (int i=0;i<clusterRoleSelectors.size();i++) { 
            if (predicate.apply(clusterRoleSelectors.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching clusterRoleSelectors. No match found.");
            return setNewClusterRoleSelectorLike(index, buildClusterRoleSelector(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1AggregationRuleFluentImpl that = (V1beta1AggregationRuleFluentImpl) o;
            if (clusterRoleSelectors != null ? !clusterRoleSelectors.equals(that.clusterRoleSelectors) :that.clusterRoleSelectors != null) return false;
            return true;
    }


    public class ClusterRoleSelectorsNestedImpl<N> extends V1LabelSelectorFluentImpl<V1beta1AggregationRuleFluent.ClusterRoleSelectorsNested<N>> implements V1beta1AggregationRuleFluent.ClusterRoleSelectorsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorBuilder builder;
        private final int index;
    
            ClusterRoleSelectorsNestedImpl(int index,V1LabelSelector item){
                    this.index = index;
                    this.builder = new V1LabelSelectorBuilder(this, item);
            }
            ClusterRoleSelectorsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1AggregationRuleFluentImpl.this.setToClusterRoleSelectors(index, builder.build());
    }
    public N endClusterRoleSelector(){
            return and();
    }

}


}
