package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1alpha1InitializerConfigurationFluent<A extends V1alpha1InitializerConfigurationFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToInitializers(int index,V1alpha1Initializer item);
    public A setToInitializers(int index,V1alpha1Initializer item);
    public A addToInitializers(V1alpha1Initializer... items);
    public A addAllToInitializers(Collection<V1alpha1Initializer> items);
    public A removeFromInitializers(V1alpha1Initializer... items);
    public A removeAllFromInitializers(Collection<V1alpha1Initializer> items);
    
/**
 * This method has been deprecated, please use method buildInitializers instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1Initializer> getInitializers();
    public List<V1alpha1Initializer> buildInitializers();
    public V1alpha1Initializer buildInitializer(int index);
    public V1alpha1Initializer buildFirstInitializer();
    public V1alpha1Initializer buildLastInitializer();
    public V1alpha1Initializer buildMatchingInitializer(io.kubernetes.client.fluent.Predicate<V1alpha1InitializerBuilder> predicate);
    public A withInitializers(List<V1alpha1Initializer> initializers);
    public A withInitializers(V1alpha1Initializer... initializers);
    public Boolean hasInitializers();
    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> addNewInitializer();
    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> addNewInitializerLike(V1alpha1Initializer item);
    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> setNewInitializerLike(int index,V1alpha1Initializer item);
    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> editInitializer(int index);
    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> editFirstInitializer();
    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> editLastInitializer();
    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> editMatchingInitializer(io.kubernetes.client.fluent.Predicate<V1alpha1InitializerBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata();
    public V1ObjectMeta buildMetadata();
    public A withMetadata(V1ObjectMeta metadata);
    public Boolean hasMetadata();
    public V1alpha1InitializerConfigurationFluent.MetadataNested<A> withNewMetadata();
    public V1alpha1InitializerConfigurationFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item);
    public V1alpha1InitializerConfigurationFluent.MetadataNested<A> editMetadata();
    public V1alpha1InitializerConfigurationFluent.MetadataNested<A> editOrNewMetadata();
    public V1alpha1InitializerConfigurationFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item);

    public interface InitializersNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1alpha1InitializerFluent<V1alpha1InitializerConfigurationFluent.InitializersNested<N>>{

        
    public N and();    public N endInitializer();
}
    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectMetaFluent<V1alpha1InitializerConfigurationFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
