package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1TokenReviewStatusFluentImpl<A extends V1TokenReviewStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1TokenReviewStatusFluent<A>{

    private Boolean authenticated;
    private String error;
    private V1UserInfoBuilder user;

    public V1TokenReviewStatusFluentImpl(){
    }
    public V1TokenReviewStatusFluentImpl(V1TokenReviewStatus instance){
            this.withAuthenticated(instance.isAuthenticated());

            this.withError(instance.getError());

            this.withUser(instance.getUser());

    }

    public Boolean isAuthenticated(){
            return this.authenticated;
    }

    public A withAuthenticated(Boolean authenticated){
            this.authenticated=authenticated; return (A) this;
    }

    public Boolean hasAuthenticated(){
            return this.authenticated != null;
    }

    public A withNewAuthenticated(boolean arg1){
            return (A)withAuthenticated(new Boolean(arg1));
    }

    public A withNewAuthenticated(String arg1){
            return (A)withAuthenticated(new Boolean(arg1));
    }

    public String getError(){
            return this.error;
    }

    public A withError(String error){
            this.error=error; return (A) this;
    }

    public Boolean hasError(){
            return this.error != null;
    }

    
/**
 * This method has been deprecated, please use method buildUser instead.
 * @return The buildable object.
 */
@Deprecated public V1UserInfo getUser(){
            return this.user!=null?this.user.build():null;
    }

    public V1UserInfo buildUser(){
            return this.user!=null?this.user.build():null;
    }

    public A withUser(V1UserInfo user){
            _visitables.remove(this.user);
            if (user!=null){ this.user= new V1UserInfoBuilder(user); _visitables.add(this.user);} return (A) this;
    }

    public Boolean hasUser(){
            return this.user != null;
    }

    public V1TokenReviewStatusFluent.UserNested<A> withNewUser(){
            return new UserNestedImpl();
    }

    public V1TokenReviewStatusFluent.UserNested<A> withNewUserLike(V1UserInfo item){
            return new UserNestedImpl(item);
    }

    public V1TokenReviewStatusFluent.UserNested<A> editUser(){
            return withNewUserLike(getUser());
    }

    public V1TokenReviewStatusFluent.UserNested<A> editOrNewUser(){
            return withNewUserLike(getUser() != null ? getUser(): new V1UserInfoBuilder().build());
    }

    public V1TokenReviewStatusFluent.UserNested<A> editOrNewUserLike(V1UserInfo item){
            return withNewUserLike(getUser() != null ? getUser(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1TokenReviewStatusFluentImpl that = (V1TokenReviewStatusFluentImpl) o;
            if (authenticated != null ? !authenticated.equals(that.authenticated) :that.authenticated != null) return false;
            if (error != null ? !error.equals(that.error) :that.error != null) return false;
            if (user != null ? !user.equals(that.user) :that.user != null) return false;
            return true;
    }


    public class UserNestedImpl<N> extends V1UserInfoFluentImpl<V1TokenReviewStatusFluent.UserNested<N>> implements V1TokenReviewStatusFluent.UserNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1UserInfoBuilder builder;
    
            UserNestedImpl(V1UserInfo item){
                    this.builder = new V1UserInfoBuilder(this, item);
            }
            UserNestedImpl(){
                    this.builder = new V1UserInfoBuilder(this);
            }
    
    public N and(){
            return (N) V1TokenReviewStatusFluentImpl.this.withUser(builder.build());
    }
    public N endUser(){
            return and();
    }

}


}
