package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1StatefulSetConditionBuilder extends V1StatefulSetConditionFluentImpl<V1StatefulSetConditionBuilder> implements VisitableBuilder<V1StatefulSetCondition,V1StatefulSetConditionBuilder>{

    V1StatefulSetConditionFluent<?> fluent;
    Boolean validationEnabled;

    public V1StatefulSetConditionBuilder(){
            this(true);
    }
    public V1StatefulSetConditionBuilder(Boolean validationEnabled){
            this(new V1StatefulSetCondition(), validationEnabled);
    }
    public V1StatefulSetConditionBuilder(V1StatefulSetConditionFluent<?> fluent){
            this(fluent, true);
    }
    public V1StatefulSetConditionBuilder(V1StatefulSetConditionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1StatefulSetCondition(), validationEnabled);
    }
    public V1StatefulSetConditionBuilder(V1StatefulSetConditionFluent<?> fluent,V1StatefulSetCondition instance){
            this(fluent, instance, true);
    }
    public V1StatefulSetConditionBuilder(V1StatefulSetConditionFluent<?> fluent,V1StatefulSetCondition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLastTransitionTime(instance.getLastTransitionTime());

            fluent.withMessage(instance.getMessage());

            fluent.withReason(instance.getReason());

            fluent.withStatus(instance.getStatus());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1StatefulSetConditionBuilder(V1StatefulSetCondition instance){
            this(instance,true);
    }
    public V1StatefulSetConditionBuilder(V1StatefulSetCondition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLastTransitionTime(instance.getLastTransitionTime());

            this.withMessage(instance.getMessage());

            this.withReason(instance.getReason());

            this.withStatus(instance.getStatus());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1StatefulSetCondition build(){
            V1StatefulSetCondition buildable = new V1StatefulSetCondition();
            buildable.setLastTransitionTime(fluent.getLastTransitionTime());
            buildable.setMessage(fluent.getMessage());
            buildable.setReason(fluent.getReason());
            buildable.setStatus(fluent.getStatus());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1StatefulSetConditionBuilder that = (V1StatefulSetConditionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
