package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ServiceListBuilder extends V1ServiceListFluentImpl<V1ServiceListBuilder> implements VisitableBuilder<V1ServiceList,V1ServiceListBuilder>{

    V1ServiceListFluent<?> fluent;
    Boolean validationEnabled;

    public V1ServiceListBuilder(){
            this(true);
    }
    public V1ServiceListBuilder(Boolean validationEnabled){
            this(new V1ServiceList(), validationEnabled);
    }
    public V1ServiceListBuilder(V1ServiceListFluent<?> fluent){
            this(fluent, true);
    }
    public V1ServiceListBuilder(V1ServiceListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1ServiceList(), validationEnabled);
    }
    public V1ServiceListBuilder(V1ServiceListFluent<?> fluent,V1ServiceList instance){
            this(fluent, instance, true);
    }
    public V1ServiceListBuilder(V1ServiceListFluent<?> fluent,V1ServiceList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1ServiceListBuilder(V1ServiceList instance){
            this(instance,true);
    }
    public V1ServiceListBuilder(V1ServiceList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1ServiceList build(){
            V1ServiceList buildable = new V1ServiceList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ServiceListBuilder that = (V1ServiceListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
