package io.kubernetes.client.models;

import io.kubernetes.client.custom.IntOrString;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1RollingUpdateDeploymentFluentImpl<A extends V1RollingUpdateDeploymentFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1RollingUpdateDeploymentFluent<A>{

    private IntOrString maxSurge;
    private IntOrString maxUnavailable;

    public V1RollingUpdateDeploymentFluentImpl(){
    }
    public V1RollingUpdateDeploymentFluentImpl(V1RollingUpdateDeployment instance){
            this.withMaxSurge(instance.getMaxSurge());

            this.withMaxUnavailable(instance.getMaxUnavailable());

    }

    public IntOrString getMaxSurge(){
            return this.maxSurge;
    }

    public A withMaxSurge(IntOrString maxSurge){
            this.maxSurge=maxSurge; return (A) this;
    }

    public Boolean hasMaxSurge(){
            return this.maxSurge != null;
    }

    public A withNewMaxSurge(final String value){
            return (A)withMaxSurge(new IntOrString(value));
    }

    public A withNewMaxSurge(final int value){
            return (A)withMaxSurge(new IntOrString(value));
    }

    public IntOrString getMaxUnavailable(){
            return this.maxUnavailable;
    }

    public A withMaxUnavailable(IntOrString maxUnavailable){
            this.maxUnavailable=maxUnavailable; return (A) this;
    }

    public Boolean hasMaxUnavailable(){
            return this.maxUnavailable != null;
    }

    public A withNewMaxUnavailable(final String value){
            return (A)withMaxUnavailable(new IntOrString(value));
    }

    public A withNewMaxUnavailable(final int value){
            return (A)withMaxUnavailable(new IntOrString(value));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1RollingUpdateDeploymentFluentImpl that = (V1RollingUpdateDeploymentFluentImpl) o;
            if (maxSurge != null ? !maxSurge.equals(that.maxSurge) :that.maxSurge != null) return false;
            if (maxUnavailable != null ? !maxUnavailable.equals(that.maxUnavailable) :that.maxUnavailable != null) return false;
            return true;
    }




}
