package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ResourceQuotaListBuilder extends V1ResourceQuotaListFluentImpl<V1ResourceQuotaListBuilder> implements VisitableBuilder<V1ResourceQuotaList,V1ResourceQuotaListBuilder>{

    V1ResourceQuotaListFluent<?> fluent;
    Boolean validationEnabled;

    public V1ResourceQuotaListBuilder(){
            this(true);
    }
    public V1ResourceQuotaListBuilder(Boolean validationEnabled){
            this(new V1ResourceQuotaList(), validationEnabled);
    }
    public V1ResourceQuotaListBuilder(V1ResourceQuotaListFluent<?> fluent){
            this(fluent, true);
    }
    public V1ResourceQuotaListBuilder(V1ResourceQuotaListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1ResourceQuotaList(), validationEnabled);
    }
    public V1ResourceQuotaListBuilder(V1ResourceQuotaListFluent<?> fluent,V1ResourceQuotaList instance){
            this(fluent, instance, true);
    }
    public V1ResourceQuotaListBuilder(V1ResourceQuotaListFluent<?> fluent,V1ResourceQuotaList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1ResourceQuotaListBuilder(V1ResourceQuotaList instance){
            this(instance,true);
    }
    public V1ResourceQuotaListBuilder(V1ResourceQuotaList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1ResourceQuotaList build(){
            V1ResourceQuotaList buildable = new V1ResourceQuotaList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ResourceQuotaListBuilder that = (V1ResourceQuotaListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
