package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1PodTemplateListBuilder extends V1PodTemplateListFluentImpl<V1PodTemplateListBuilder> implements VisitableBuilder<V1PodTemplateList,V1PodTemplateListBuilder>{

    V1PodTemplateListFluent<?> fluent;
    Boolean validationEnabled;

    public V1PodTemplateListBuilder(){
            this(true);
    }
    public V1PodTemplateListBuilder(Boolean validationEnabled){
            this(new V1PodTemplateList(), validationEnabled);
    }
    public V1PodTemplateListBuilder(V1PodTemplateListFluent<?> fluent){
            this(fluent, true);
    }
    public V1PodTemplateListBuilder(V1PodTemplateListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1PodTemplateList(), validationEnabled);
    }
    public V1PodTemplateListBuilder(V1PodTemplateListFluent<?> fluent,V1PodTemplateList instance){
            this(fluent, instance, true);
    }
    public V1PodTemplateListBuilder(V1PodTemplateListFluent<?> fluent,V1PodTemplateList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1PodTemplateListBuilder(V1PodTemplateList instance){
            this(instance,true);
    }
    public V1PodTemplateListBuilder(V1PodTemplateList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1PodTemplateList build(){
            V1PodTemplateList buildable = new V1PodTemplateList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1PodTemplateListBuilder that = (V1PodTemplateListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
