package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1PodDNSConfigFluent<A extends V1PodDNSConfigFluent<A>> extends Fluent<A>{


    public A addToNameservers(int index,String item);
    public A setToNameservers(int index,String item);
    public A addToNameservers(String... items);
    public A addAllToNameservers(Collection<String> items);
    public A removeFromNameservers(String... items);
    public A removeAllFromNameservers(Collection<String> items);
    public List<String> getNameservers();
    public String getNameserver(int index);
    public String getFirstNameserver();
    public String getLastNameserver();
    public String getMatchingNameserver(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withNameservers(List<String> nameservers);
    public A withNameservers(String... nameservers);
    public Boolean hasNameservers();
    public A addToOptions(int index,V1PodDNSConfigOption item);
    public A setToOptions(int index,V1PodDNSConfigOption item);
    public A addToOptions(V1PodDNSConfigOption... items);
    public A addAllToOptions(Collection<V1PodDNSConfigOption> items);
    public A removeFromOptions(V1PodDNSConfigOption... items);
    public A removeAllFromOptions(Collection<V1PodDNSConfigOption> items);
    
/**
 * This method has been deprecated, please use method buildOptions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1PodDNSConfigOption> getOptions();
    public List<V1PodDNSConfigOption> buildOptions();
    public V1PodDNSConfigOption buildOption(int index);
    public V1PodDNSConfigOption buildFirstOption();
    public V1PodDNSConfigOption buildLastOption();
    public V1PodDNSConfigOption buildMatchingOption(io.kubernetes.client.fluent.Predicate<V1PodDNSConfigOptionBuilder> predicate);
    public A withOptions(List<V1PodDNSConfigOption> options);
    public A withOptions(V1PodDNSConfigOption... options);
    public Boolean hasOptions();
    public V1PodDNSConfigFluent.OptionsNested<A> addNewOption();
    public V1PodDNSConfigFluent.OptionsNested<A> addNewOptionLike(V1PodDNSConfigOption item);
    public V1PodDNSConfigFluent.OptionsNested<A> setNewOptionLike(int index,V1PodDNSConfigOption item);
    public V1PodDNSConfigFluent.OptionsNested<A> editOption(int index);
    public V1PodDNSConfigFluent.OptionsNested<A> editFirstOption();
    public V1PodDNSConfigFluent.OptionsNested<A> editLastOption();
    public V1PodDNSConfigFluent.OptionsNested<A> editMatchingOption(io.kubernetes.client.fluent.Predicate<V1PodDNSConfigOptionBuilder> predicate);
    public A addToSearches(int index,String item);
    public A setToSearches(int index,String item);
    public A addToSearches(String... items);
    public A addAllToSearches(Collection<String> items);
    public A removeFromSearches(String... items);
    public A removeAllFromSearches(Collection<String> items);
    public List<String> getSearches();
    public String getSearch(int index);
    public String getFirstSearch();
    public String getLastSearch();
    public String getMatchingSearch(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withSearches(List<String> searches);
    public A withSearches(String... searches);
    public Boolean hasSearches();

    public interface OptionsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1PodDNSConfigOptionFluent<V1PodDNSConfigFluent.OptionsNested<N>>{

        
    public N and();    public N endOption();
}


}
